///////////////////////////////////////////////////////////////////////////////
//
//  File:       repfactl.h
//
//  Class:      ReplayFactoryLinux - Concrete
//  
//  Hierarchy:  ReplayFactoryLinux - ReplayFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is the concrete factory for creating Linux based
//      objects used in Replay.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _repfactl_h_
#define _repfactl_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repfact.h"


///////////////////////////////////////////////////////////////////////////////
//  ReplayFactoryLinux Class Definition
///////////////////////////////////////////////////////////////////////////////
class ReplayFactoryLinux : public ReplayFactory
{
    public:

        //  Deletion.
        virtual ~ReplayFactoryLinux ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation.
        ReplayFactoryLinux ( const KString& iName );

        //  Factory methods.
        virtual Canvas*      createCanvas      ( const KString& iName );
        virtual Keyboard*    createKeyboard    ( const KString& iName );
        virtual Joystick*    createJoystick    ( const KString& iName );
        virtual Mouse*       createMouse       ( const KString& iName );
        virtual Sound*       createSound       ( const KString& iName );
        virtual Disk*        createDisk        ( const KString& iName );
        virtual Network*     createNetwork     ( const KString& iName );
        virtual Clock*       createClock       ( const KString& iName );
        virtual GameFactory* createGameFactory ( const KString& iName );
        virtual CPU*         createCPU         (
            const KString&        iName,
            const CPU::CPUType    eCPUType,
            Game*                 pGame,
            AddrSpace*            pSpace,
            const CPU::CPUPurpose ePurpose      = CPU::GAME,
            const Byte            bCONSERVATIVE = FALSE
        );


    private:

        //  Static Member Data.
        static ReplayFactoryLinux sm_replayFactoryLinux;
};

#endif
