///////////////////////////////////////////////////////////////////////////////
//
//  File:    meddler.cpp
//
//  Class:   Meddler
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class represents an object that is used to modify the state
//      of a game in Replay.  It is used when the game needs to be controlled
//      by in external source other than, or in addition to, the user.
//
//      This class is an abstract object representing the interface for
//      all Meddler objects.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdlib.h>

//  Application Headers.
#include "reptypes.h"
#include "meddler.h"
#include "replay.h"
#include "keyb.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: Meddler
//
//  Description:
//
//      This is the main constructor for a meddler object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//      pGame (input)
//          A pointer to the game that is currently being run by Replay.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Meddler::Meddler(
    const KString&  iName,
    Game*           pGame
)
:
    RepBase           ( iName ),
    m_pGame           ( pGame ),
    m_bComplete       ( FALSE )
{
    ASSERT( m_pGame != NULL );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is initialization function for a Meddler object.  It is to
//      be called from the build method and performs functions we would 
//      normally do in the constructor.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
Meddler::init(
)
{
    //  Nothing to do.
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Meddler
//
//  Description:
//
//      This is the destructor for a meddler object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Meddler::~Meddler(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: activate
//
//  Description:
//
//      This function can be called to activate the meddling.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
Meddler::activate(
)
{
    //  Nothing done by default.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: deactivate
//
//  Description:
//
//      This function can be called to deactivate the meddling.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
Meddler::deactivate(
)
{
    //  The meddler can play around with the virtual settings of the
    //  keyboard so when the meddler is deactivated, we should make sure
    //  everything is back to normal.
    Replay::s_instance( ).getKeyboard( )->clearVirtual( ); 
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: terminate
//
//  Description:
//
//      This function can be called to terminate the meddling.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
Meddler::terminate(
)
{
    //  Mark the meddler as complete.
    m_bComplete = TRUE;

    //  Make sure to deactivate the meddler.
    deactivate( );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getDecoration
//
//  Description:
//
//      This member is to return the decoration that is to be used to indicate
//      to the user that the meddler is meddling.  By default, no decoration
//      is shown.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The decoration.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
Meddler::getDecoration(
) const
{
    //  The name of the class.
    static const KString decoration( "" );

    return( decoration );
}
