///////////////////////////////////////////////////////////////////////////////
//
//  File:       movie.h
//
//  Class:      MovieMeddler - Abstract
//  
//  Hierarchy:  MovieMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a base class for Meddlers that record and
//      play back movies of Replay games.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _movie_h_
#define _movie_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "meddler.h"
#include "kstring.h"
#include "kplist.h"


//  Forward Class Declarations.
class Game;
class AppFile;
class CtrlMap;
class Keyboard;
class Joystick;


///////////////////////////////////////////////////////////////////////////////
//  MovieMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class MovieMeddler : public Meddler
{
    public:

        //  Deletion.
        virtual ~MovieMeddler ( );

    protected:

        //  The following embedded class indicates the time when the
        //  value of a control map has changed along with the map modifier
        //  and state.  The movie meddlers either create or read a
        //  list of these which together indicate what is changing in the
        //  game from external (i.e. the user) sources.
        class Frame
        {
            public:
                DWord m_dwTime;
                DWord m_dwCtrlMapIndex;
                char  m_cModifier;
                Byte  m_bState;
        };
        
        //  Creation/Initialization .
        MovieMeddler ( 
            const KString& iName, Game* pGame, const Byte bAllowCreate 
        );
        virtual void init ( );

        //  Member data.
        Byte                     m_bAllowCreate;
        DWord                    m_dwTime;
        KPtrList<Frame>          m_frameList;
        AppFile*                 m_pFile;
        Keyboard*                m_pKeyboard;
        Joystick*                m_pJoystick;
        const KPtrList<CtrlMap>& m_rCtrlMapList;

    private:

};


#endif
