///////////////////////////////////////////////////////////////////////////////
//
//  File:       netgame.h
//
//  Class:      NetGameMeddler - Abstract
//  
//  Hierarchy:  NetGameMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents a base class for Meddlers that are used in
//      the playing of networked Replay games.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _netgame_h_
#define _netgame_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "meddler.h"
#include "kstring.h"
#include "kplist.h"
#include "network.h"


//  Forward Class Declarations.
class Game;
class CtrlMap;
class Keyboard;
class Joystick;


///////////////////////////////////////////////////////////////////////////////
//  NetGameMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class NetGameMeddler : public Meddler
{
    public:

        //  Deletion.
        virtual ~NetGameMeddler ( );

        //  Interface.
        virtual const KString& getDecoration ( ) const;
        virtual void  terminate              ( );

    protected:

        //  An unassigned player can be player 0 since player numbering
        //  starts at player 1.
        typedef enum
        {
            PLAYER_UNASSIGNED = 0
        }
        Defines;

        //  Creation/Initialization .
        NetGameMeddler    ( const KString& iName, Game* pGame );
        virtual void init ( );

        //  Utility.
        void getKeyState  ( DWord* pdwState );
        void setKeyState  ( DWord* pdwState );
        void setPlayerNum ( DWord dwPlayerNum );

        //  Member data.
        Network*                 m_pNetwork;
        Keyboard*                m_pKeyboard;
        Joystick*                m_pJoystick;
        DWord                    m_dwPlayerNum;
        Network::Msg*            m_pMsg;
        const KPtrList<CtrlMap>& m_rCtrlMapList; 
        KString                  m_decoration;
        Byte                     m_bShowDecoration;

    private:

};


#endif
