///////////////////////////////////////////////////////////////////////////////
//
//  File:       record.h
//
//  Class:      MovieRecordMeddler - Concrete
//  
//  Hierarchy:  MovieRecordMeddler - MovieMeddler - Meddler - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used to record a movie of the current game being 
//      emulated.  It can be played back at a later date with the 
//      MoviePlayMeddler.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _record_h_
#define _record_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "movie.h"
#include "kstring.h"


//  Forward Class Declarations.
class Game;


///////////////////////////////////////////////////////////////////////////////
//  MovieRecordMeddler Class Definition
///////////////////////////////////////////////////////////////////////////////
class MovieRecordMeddler : public MovieMeddler
{
    public:

        //  Build method.
        static MovieRecordMeddler* s_build( const KString& iName, Game* pGame );

        //  Creation/Deletion.
        virtual ~MovieRecordMeddler ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface. 
        virtual void  update                 ( );
        virtual void  terminate              ( );
        virtual const KString& getDecoration ( ) const;

    protected:

        //  Creation/Initialization.
        MovieRecordMeddler ( const KString& iName, Game* pGame );
        virtual void init  ( );

        //  Member Data.
        Byte* m_pbLastKeyStates;

    private:

};


#endif
