///////////////////////////////////////////////////////////////////////////////
//
//  File:    clock.cpp
//
//  Class:   Clock
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The Clock class is an abstract base class encapsulating timing
//      control.  A derived class for each platform should be created
//      from this base.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "clock.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: Clock
//
//  Description:
//
//      This is the main constructor for a clock object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Clock::Clock(
    const KString&  iName
)
:
    RepBase           ( iName ),
    m_dwFPS           ( 60 ),
    m_dwMeasuredFPS   ( 0 ),
    m_dwFrameSkip     ( 0 ),
    m_dwInterval      ( 1000000 / 60 ),
    m_dwLastTime      ( 0 ),
    m_bThrottle       ( TRUE )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Clock
//
//  Description:
//
//      This is the destructor for a clock object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Clock::~Clock(
)
{
    //  Nothing to do.
}
