///////////////////////////////////////////////////////////////////////////////
//
//  File:       clock.h
//
//  Class:      Clock - Abstract
//  
//  Hierarchy:  Clock - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Clock class is an abstract base class encapsulating timing
//      control.  A derived class for each platform should be created
//      from this base.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _clock_h_
#define _clock_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Clock Class Definition
///////////////////////////////////////////////////////////////////////////////
class Clock : public RepBase
{
    public:

        //  Deletion.
                 Clock ( const KString& iName );
        virtual ~Clock ( );

        //  Access.
        virtual DWord getTime ( ) const = 0;

        //  Frame Control.
        void         setFPS          ( DWord dwFPS );
        DWord        getFPS          ( ) const;
        void         setFrameSkip    ( DWord dwFrameSkip );
        void         setThrottle     ( Byte  bThrottle );
        virtual void frameWait       ( ) = 0;
        DWord        getMeasuredFPS  ( ) const;

    protected:


        //  Member Data.
        DWord m_dwFPS;
        DWord m_dwMeasuredFPS;
        DWord m_dwFrameSkip;
        DWord m_dwInterval;
        DWord m_dwLastTime;
        Byte  m_bThrottle;

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Clock Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
void
Clock::setFPS(
    DWord dwFPS
)
{
    ASSERT( dwFPS > 0 );
    m_dwFPS = dwFPS;
    m_dwInterval = ( m_dwFrameSkip + 1 ) * 1000000 / m_dwFPS;
}

inline
DWord
Clock::getFPS(
) const
{
    return( m_dwFPS );
}

inline
void
Clock::setFrameSkip(
    DWord dwFrameSkip
)
{
    m_dwFrameSkip = dwFrameSkip;
    m_dwInterval = ( m_dwFrameSkip + 1 ) * 1000000 / m_dwFPS;
}

inline
void
Clock::setThrottle(
    Byte bThrottle
)
{
    m_bThrottle = bThrottle;
}

inline
DWord
Clock::getMeasuredFPS(
) const
{
    return( m_dwMeasuredFPS );
}

#endif
