///////////////////////////////////////////////////////////////////////////////
//
//  File:       config.h
//
//  Class:      Configuration - Abstract
//  
//  Hierarchy:  Configuration - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is used by the Replay application for Configuration
//      duties.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _config_h_
#define _config_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdlib.h>
#include <string.h>

//  Application Headers.
#include "kpslist.h"
#include "reptypes.h"
#include "repbase.h"

//  Forward Class Declarations.
class Registry;
class Parameter;

///////////////////////////////////////////////////////////////////////////////
//  Configuration Class Definition
///////////////////////////////////////////////////////////////////////////////
class Configuration : public RepBase
{
    public:

        //  Deletion.
        virtual ~Configuration ( );

        //  Singleton Access.
        static Configuration& s_instance ( );
   
        //  Initialization
        void initialize ( int32 nArgc, char** ppstrArgv );

        //  Command-line Access.
        const char* getExecutable ( ) const; 
        const Byte  getParam      ( 
            const KString& paramName, int32* pnResult 
        );
        const Byte  getParam      ( 
            const KString& paramName, KString* pResult 
        );
        const Byte  getParam      ( 
            const KString& paramName, Byte* pbResult = NULL 
        );

        //  Registry Access.
        Registry* getSettingsRegistry  ( ) const;

    protected:

        //  Creation/Deletion.
        Configuration ( const KString& iName );

        //  Utility.
        void       processCommandLine   ( int32 nArgc, char** ppstrArgv );
        void       addParam             ( 
            const char* pstrParameter,
            const char* pstrArgumentDesc,
            const char* pstrParameterDesc
        );
        Parameter* findParam            ( const char* pstrParameter ) const;
        void       usage                ( );
        

    private:

        //  Utility.
        Byte isParam ( const char* pstrCompare ) const;

        //  Member Data.
        Byte                        m_bInitialized;
        int32                       m_nArgc;
        char**                      m_ppstrArgv;
        Registry*                   m_pSettingsRegistry;
        KPtrList<Parameter>         m_parameterList;

        //  Static Member Data.
        static Configuration*       sm_pInstance;
};


///////////////////////////////////////////////////////////////////////////////
//  Configuration Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
const 
char*
Configuration::getExecutable(
) const
{
    ASSERT( m_bInitialized );
    return( m_ppstrArgv[ 0 ] );
}

inline
Registry*
Configuration::getSettingsRegistry(
) const
{
    ASSERT( m_pSettingsRegistry != NULL );
    return( m_pSettingsRegistry );
}

inline
Byte
Configuration::isParam(
    const char* pstrCompare
) const
{
    ASSERT( pstrCompare != NULL );

    return( 
        ( strncmp( pstrCompare, "-", 1 )  == 0 ) ||
        ( strncmp( pstrCompare, "--", 2 ) == 0 ) ||
        ( strncmp( pstrCompare, "+", 1 )  == 0 )
    );
}



#endif
