///////////////////////////////////////////////////////////////////////////////
//
//  File:    main.cpp
//
//  Class:   N/A
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This contains the mainline routine for Replay.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <signal.h>

//  Application Headers.
#include "replay.h"
#include "config.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: main
//
//  Description:
//
//      This function is the main entry point for the Replay application.
//
//  Parameters:
//
//      argc (input)
//          The number of parameters passed on the command line.
//
//      argv (input)
//          The parameters passed on the command line.
//
//  Returns:
//      The status of the program on exit.
//
///////////////////////////////////////////////////////////////////////////////
int
main(
    int32  nArgc,
    char** ppstrArgv
)
{
    //  Set up some signals.
    signal( SIGPIPE, SIG_IGN );
 
    //  Set up the Replay configuration.
    Configuration::s_instance( ).initialize( nArgc, ppstrArgv );

    //  Run the application.
    return( Replay::s_instance( ).run( ) );
}
