///////////////////////////////////////////////////////////////////////////////
//
//  File:       page.h
//
//  Class:      Page - Abstract
//  
//  Hierarchy:  Page - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Page class represents a viewable screen for the Replay 
//      application.  Pages are contained on the Canvas of the application.
//      This is an abstract base class for platform specific derived classes 
//      that implement the interface for the hardware of the platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _page_h_
#define _page_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Page Class Definition
///////////////////////////////////////////////////////////////////////////////
class Page : public RepBase
{
    public:

        //  Creation/Deletion.
        Page ( 
            const KString& iName, 
            const DWord    dwWidth, 
            const DWord    dwHeight,
            const Byte     bTransposed = FALSE
        );
        virtual ~Page ( );

        //  Interface.
        DWord         getWidth        ( ) const;
        DWord         getHeight       ( ) const;
        virtual void  transpose       ( );

    protected:

        //  Member data.
        DWord   m_dwWidth;
        DWord   m_dwHeight;
        Byte    m_bTransposed; 

    private:

};

///////////////////////////////////////////////////////////////////////////////
//  Page Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
DWord
Page::getWidth(
) const
{
    return( m_bTransposed ? m_dwHeight : m_dwWidth );
}

inline
DWord
Page::getHeight(
) const
{
    return( m_bTransposed ? m_dwWidth : m_dwHeight );
}

#endif
