///////////////////////////////////////////////////////////////////////////////
//
//  File:    param.cpp
//
//  Class:   Parameter
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The Parameter class is an class encapsulating a command line
//      parameter.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "param.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: Parameter
//
//  Description:
//
//      This is the main constructor for a parameter object.
//
//  Parameters:
//
//      parameter (input)
//          The name of the parameter (as it would appear on the command line).
//
//      argumentDesc (input)
//          The description of the argument passed to the command line (if
//          any).
//
//      parameterDesc (input)
//          The description of the parameter.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Parameter::Parameter(
    const KString& parameter,
    const KString& argumentDesc,
    const KString& parameterDesc
)
:
    RepBase           ( parameter ),
    m_bFound          ( FALSE ),
    m_parameter       ( parameter ),
    m_parameterDesc   ( parameterDesc ),
    m_argument        ( ),
    m_argumentDesc    ( argumentDesc )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Parameter
//
//  Description:
//
//      This is the destructor for a parameter object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Parameter::~Parameter(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the parameter object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
Parameter::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "Parameter" );

    return( className );
}



