///////////////////////////////////////////////////////////////////////////////
//
//  File:       repbase.h
//
//  Class:      RepBase - Abstract
//  
//  Hierarchy:  RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//      All objects in Replay should derive from RepBase.  It provides some
//      basic functionality.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _repbase_h_
#define _repbase_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
//  Application Headers.
#include "reptypes.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  Macros.
///////////////////////////////////////////////////////////////////////////////
//  The following specifies the major and minor revision numbers of this
//  release of the Replay application.
#define REPLAY_MAJOR_REVISION  "1"
#define REPLAY_MINOR_REVISION  "0"


//  Forward class declarations.
class AppFile;


///////////////////////////////////////////////////////////////////////////////
//  RepBase Class Definition
///////////////////////////////////////////////////////////////////////////////
class RepBase
{
    public:

        //  Creation/Deletion.
                 RepBase ( const KString& iName );
        virtual ~RepBase ( );

        //  Identification.
        virtual const KString& getClassName    ( ) const = 0;
                const KString& getInstanceName ( ) const;
        
        //  Logging.
#ifndef NDEBUG
        void check      ( const Byte bTestThis, char* pstrFormat, ... ) const;
#endif
        void confirm    ( const Byte bTestThis, char* pstrFormat, ... ) const;
        void fatalError ( char* pstrFormat, ... ) const;

        //  Persistence.
        virtual Byte save ( AppFile* pSaveFile );
        virtual Byte load ( AppFile* pLoadFile );

    protected:


    private:

        //  We don't allow copy.
        RepBase ( RepBase& );


        //  Member Data.
        KString m_iName;
};


///////////////////////////////////////////////////////////////////////////////
//  RepBase Inline Methods.
///////////////////////////////////////////////////////////////////////////////
inline
const
KString&
RepBase::getInstanceName(
) const
{
    return( m_iName );

}


///////////////////////////////////////////////////////////////////////////////
//  RepBase Macros.
///////////////////////////////////////////////////////////////////////////////
#define CONFIRM confirm
#ifdef NDEBUG
#define CHECK0(t,f)           ( ( void ) 0 )
#define CHECK1(t,f,a)         ( ( void ) 0 )
#define CHECK2(t,f,a,b)       ( ( void ) 0 )
#define CHECK3(t,f,a,b,c)     ( ( void ) 0 )
#define CHECK4(t,f,a,b,c,d)   ( ( void ) 0 )
#define CHECK5(t,f,a,b,c,d,e) ( ( void ) 0 )
#else
#define CHECK0(t,f)           check( t, f )
#define CHECK1(t,f,a)         check( t, f, a )
#define CHECK2(t,f,a,b)       check( t, f, a, b )
#define CHECK3(t,f,a,b,c)     check( t, f, a, b, c )
#define CHECK4(t,f,a,b,c,d)   check( t, f, a, b, c, d )
#define CHECK5(t,f,a,b,c,d,e) check( t, f, a, b, c, d, e )
#endif

#endif
