///////////////////////////////////////////////////////////////////////////////
//
//  File:       repfact.h
//
//  Class:      ReplayFactory - Abstract
//  
//  Hierarchy:  ReplayFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This object is an abstract factory & singleton for creating various 
//      platform dependant objects.  This uses an Abstract Factory 
//      pattern to provide an interface for clients.  There should be a 
//      concrete factory class derived from this for each platform 
//      Replay runs on.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _repfact_h_
#define _repfact_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "cpu.h"

//  Forward class declarations.
class Canvas;
class Keyboard;
class Joystick;
class Mouse;
class Sound;
class Disk;
class Network;
class Clock;
class GameFactory;


///////////////////////////////////////////////////////////////////////////////
//  ReplayFactory Class Definition
///////////////////////////////////////////////////////////////////////////////
class ReplayFactory : public RepBase
{
    public:

        //  Deletion.
        virtual ~ReplayFactory ( );

        //  Singleton Access.
        static ReplayFactory& s_instance ( );
   
        //  Factory methods.
        virtual Canvas*      createCanvas      ( const KString& iName ) = 0;
        virtual Keyboard*    createKeyboard    ( const KString& iName ) = 0;
        virtual Joystick*    createJoystick    ( const KString& iName ) = 0;
        virtual Mouse*       createMouse       ( const KString& iName ) = 0;
        virtual Sound*       createSound       ( const KString& iName ) = 0;
        virtual Disk*        createDisk        ( const KString& iName ) = 0;
        virtual Network*     createNetwork     ( const KString& iName ) = 0;
        virtual Clock*       createClock       ( const KString& iName ) = 0;
        virtual GameFactory* createGameFactory ( const KString& iName ) = 0; 
        virtual CPU*         createCPU         ( 
            const KString&        iName,
            const CPU::CPUType    eCPUType,
            Game*                 pGame,
            AddrSpace*            pSpace,
            const CPU::CPUPurpose ePurpose      = CPU::GAME,
            const Byte            bCONSERVATIVE = FALSE
        ) = 0; 


    protected:

        //  Creation is protected since this is a singleton.
        ReplayFactory ( const KString& iName );

    private:

        //  Static Member Data.
        static ReplayFactory* sm_pInstance;
};


#endif
