///////////////////////////////////////////////////////////////////////////////
//
//  File:       ssscfg.h
//
//  Class:      SSStateControlConfig - Abstract
//  
//  Hierarchy:  SSStateControlConfig - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for allowing the
//      user to configure the game controls.  It allows for setting
//      both the global Replay game controls and for setting the current
//      game's controls.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ssscfg_h_
#define _ssscfg_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"
#include "ctrlmap.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateControlConfig Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateControlConfig : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateControlConfig ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateControlConfig ( );

        //  Interface.
        virtual void    setGameInfo ( GameInfo* pGameInfo );
        virtual Action  execute     ( ColourTable* pColourTable );
        virtual void    fillHelp    ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  Control handling.
        void     addItems       ( );
        void     updateCurItem  ( );
        KString* createItem     ( 
            const CtrlMap* pCtrlMap, const DWord dwIndex 
        );
        void     updateCtrlMaps ( const DWord dwSwitchSelected );
        void     resetCtrlMaps  ( );

        //  Member Data.
        Byte                 m_bGlobal;
        Byte                 m_bWaiting;
        Byte                 m_bControlsChanged;
        DWord                m_dwLastSwitchOn;
        KString              m_resourcePostfix;
        DigitalController*   m_pController;
        CtrlMap::Association m_eAssoc;

    private:

};

#endif
