///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssdemo.h
//
//  Class:      SSStateDemo - Concrete
//  
//  Hierarchy:  SSStateDemo - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for showing the
//      demo of the current game while the selection is being made.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssdemo_h_
#define _sssdemo_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "sssbase.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateDemo Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateDemo : public SSStateBase
{
    public:

        //  Creation/Deletion.
        SSStateDemo ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateDemo ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual Action  execute   ( ColourTable* pColourTable );
        virtual Bitmap* getScreen ( );
        virtual void    fillHelp  ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  Member Data.

    private:

};

#endif
