///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssdip.h
//
//  Class:      SSStateDipSwitch - Concrete
//  
//  Hierarchy:  SSStateDipSwitch - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for setting the
//      dip switches of the current game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssdip_h_
#define _sssdip_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class DipSwitch;
class Setting;

///////////////////////////////////////////////////////////////////////////////
//  SSStateDipSwitch Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateDipSwitch : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateDipSwitch ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateDipSwitch ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void    setGameInfo ( GameInfo* pGameInfo );
        virtual Action  execute     ( ColourTable* pColourTable );
        virtual void    fillHelp    ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  List Handling.
        void     addItems       ( );
        void     updateCurItem  ( );

        //  Utility.
        DipSwitch* curDipSwitch  ( ) const;
        Setting*   curSetting    ( ) const;

        //  Member Data.

    private:

};

#endif
