///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssinit.h
//
//  Class:      SSStateInitialize - Concrete
//  
//  Hierarchy:  SSStateInitialize - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for initializing
//      a game.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssinit_h_
#define _sssinit_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "sssbase.h"
#include "clip.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Clock;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateInitialize Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateInitialize : public SSStateBase
{
    public:

        //  Creation/Deletion.
        SSStateInitialize ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateInitialize ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void    setGameInfo ( GameInfo* pGameInfo );
        virtual Action  execute     ( ColourTable* pColourTable );
        virtual Bitmap* getScreen   ( );
        virtual void    fillHelp    ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  Member Data.
        Byte     m_bNewGame;
        Byte     m_bWaiting;
        DWord    m_dwStartTime;
        Bitmap*  m_pScreenBitmap;
        Clipping m_clipping;
        Clock*   m_pClock;

        //  Static Member Data.
        static const DWord sm_dwTimeDelay;

    private:

};

#endif
