///////////////////////////////////////////////////////////////////////////////
//
//  File:    sssjoyc.cpp
//
//  Class:   SSStateJoyConfig
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for allowing the
//      user to configure the joystick controls.  It allows for setting
//      both the global Replay game controls and for setting the current
//      game's controls.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "sssjoyc.h"
#include "replay.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: SSStateJoyConfig
//
//  Description:
//
//      This is the main constructor for the selection screen joy configuration
//      state object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object. 
//
//      pSelectScreen (input)
//          The selection screen the state belongs to.
//
//      pCanvas (input)
//          The canvas used by the selection screen.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SSStateJoyConfig::SSStateJoyConfig(
    const KString& iName,
    SelectScreen*  pSelectScreen,
    Canvas*        pCanvas
)
:
    SSStateControlConfig ( iName, pSelectScreen, pCanvas )
{
    //  Override the values for the configurable member data to indicate
    //  that we're configuring the Joystick.
    m_resourcePostfix = ".joy";
    m_pController     = Replay::s_instance( ).getJoystick( );
    m_eAssoc          = CtrlMap::JOYSTICK;
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~SSStateJoyConfig
//
//  Description:
//
//      This is the destructor for the selection screen joy configuration 
//      state object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
SSStateJoyConfig::~SSStateJoyConfig(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the select screen game info state 
//      object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
SSStateJoyConfig::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "SSStateJoyConfig" );

    return( className );
}
