///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssjoyc.h
//
//  Class:      SSStateJoyConfig - Concrete
//  
//  Hierarchy:  SSStateJoyConfig - SSStateControlConfig - 
//                  SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for allowing the
//      user to configure the joystick controls.  It allows for setting
//      both the global Replay game controls and for setting the current
//      game's controls.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssjoyc_h_
#define _sssjoyc_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssscfg.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class CtrlMap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateJoyConfig Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateJoyConfig : public SSStateControlConfig
{
    public:

        //  Creation/Deletion.
        SSStateJoyConfig ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateJoyConfig ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

    private:

};

#endif
