///////////////////////////////////////////////////////////////////////////////
//
//  File:       ssslist.h
//
//  Class:      SSStateList - Abstract
//  
//  Hierarchy:  SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is an abstract selection screen state that can be derived from
//      to create states that display list of items that can be scrolled.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ssslist_h_
#define _ssslist_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "sssbase.h"
#include "kplist.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class GfxSet;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateList Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateList : public SSStateBase
{
    public:

        //  Creation/Deletion.
        SSStateList ( 
            const KString& iName, 
            SelectScreen*  pSelectScreen, 
            Canvas*        pCanvas,
            Byte           bScrollLock = FALSE,
            Byte           bCenter = FALSE
        );
        virtual ~SSStateList ( );

        //  Interface.
        virtual Action  execute   ( ColourTable* pColourTable );
        virtual Bitmap* getScreen ( );

    protected:

        //  Utility for derived classes.
        void clearHeader    ( );
        void clearLines     ( );
        void checkForScroll ( );

        //  Member Data.
        Bitmap*           m_pScreenBitmap;
        KPtrList<KString> m_headerList;
        KPtrList<KString> m_lineList;
        Byte              m_bScrollLock;
        Byte              m_bCenter;
        DWord             m_dwTopLine;
        DWord             m_dwBotLine;
        DWord             m_dwCurLine;
        GfxSet*           m_pFont;
        int32             m_nFontHeight;
        int32             m_nFontWidth;

    private:

};

#endif
