///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssmenu.h
//
//  Class:      SSStateMainMenu - Concrete
//  
//  Hierarchy:  SSStateMainMenu - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for displaying
//      and processing the main menu of options.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssmenu_h_
#define _sssmenu_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;

///////////////////////////////////////////////////////////////////////////////
//  SSStateMainMenu Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateMainMenu : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateMainMenu ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateMainMenu ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual void    setState           ( );
        virtual Action  execute            ( ColourTable* pColourTable );
        virtual Action  processSelection   ( );
        virtual void    fillHelp           ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );

    protected:

        //  The possible menu choices.
        typedef enum
        {
            CHOICE_NONE,
            CHOICE_RETURN,
            CHOICE_KEY__CONFIG,
            CHOICE_JOY_CONFIG,
            CHOICE_DIP_SWITCH,
            CHOICE_SAVE_GAME,
            CHOICE_LOAD_GAME,
            CHOICE_RECORD_MOVIE,
            CHOICE_PLAY_MOVIE,
            CHOICE_STOP_MOVIE,
            CHOICE_START_SERVER,
            CHOICE_START_CLIENT,
            CHOICE_STOP_NET,
            CHOICE_EXIT
        }
        Choice;

        //  List Handling.
        void     addItems       ( );
        void     updateCurItem  ( );

        //  Member Data.
        Byte        m_bMoviePlaying;
        Byte        m_bMovieRecording;
        Byte        m_bRunningServer;
        Byte        m_bRunningClient;
        Byte        m_bStartUp;
        Choice      m_aeChoices[ 32 ];
        

    private:

};

#endif
