///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssmsg.h
//
//  Class:      SSStateMessage - Concrete
//  
//  Hierarchy:  SSStateMessage - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for displaying an
//      informational message to the user.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssmsg_h_
#define _sssmsg_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateMessage Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateMessage : public SSStateList
{
    public:

        //  The possible messages to display.
        typedef enum
        {
            MSG_NONE,
            MSG_SAVE_GOOD,
            MSG_SAVE_BAD,
            MSG_LOAD_GOOD,
            MSG_LOAD_BAD,
            MSG_RECORD_GOOD,
            MSG_RECORD_BAD,
            MSG_RECORD_STOP,
            MSG_PLAY_GOOD,
            MSG_PLAY_BAD,
            MSG_PLAY_STOP,
            MSG_NET_INUSE,
            MSG_NET_NOSERV,
            MSG_NET_STOPPED,
            MSG_NET_LEFT,
            MSG_NET_MISSING
        }
        Message;

        //  Creation/Deletion.
        SSStateMessage ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateMessage ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual Action  execute       ( ColourTable* pColourTable );
        virtual void    fillHelp      ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );
        static void     s_setMessage  ( const Message eMessage );

    protected:

        //  Utility.
        void setMessage  ( );

        //  Member Data.
        Message m_eMessage;

        //  Static Member Data.
        static Message sm_eMessage;

    private:

};

#endif
