///////////////////////////////////////////////////////////////////////////////
//
//  File:       sssserv.h
//
//  Class:      SSStateServer - Concrete
//  
//  Hierarchy:  SSStateServer - SSStateList - SSStateBase - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is the selection screen state responsible for waiting
//      for network clients to connect when Replay is acting as a server.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sssserv_h_
#define _sssserv_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "reptypes.h"
#include "repbase.h"
#include "ssslist.h"
#include "network.h"

//  Forward class declarations.
class SelectScreen;
class Canvas;
class Bitmap;
class ColourTable;

///////////////////////////////////////////////////////////////////////////////
//  SSStateServer Class Definition
///////////////////////////////////////////////////////////////////////////////
class SSStateServer : public SSStateList
{
    public:

        //  Creation/Deletion.
        SSStateServer ( 
            const KString& iName, SelectScreen* pSelectScreen, Canvas* pCanvas 
        );
        virtual ~SSStateServer ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Interface.
        virtual Action  execute   ( ColourTable* pColourTable );
        virtual void    fillHelp  ( 
            Bitmap* pBitmap, Canvas::Font eFont, ColourTable* pColourTable 
        );
        virtual void    setState  ( );

    protected:

        //  The synchronization messages.
        typedef enum
        {
            SYNCHRO_NONE,

            SYNCHRO_RECV_START,
            SYNCHRO_SEND_GAME,
            SYNCHRO_SEND_DIPS,
            SYNCHRO_SEND_READY,
            SYNCHRO_RECV_READY
        }
        Synchro;

        typedef enum
        {
            CLIENT_NONE = 0xffff
        }
        ClientNone;

        //  Utility.
        void updateHeader     ( );
        void continueSynchro  ( );
        void synchroRecvStart ( );
        void synchroSendGame  ( );
        void synchroSendDips  ( );
        void synchroSendReady ( );
        void synchroRecvReady ( );
        void pingConnections  ( );
        void sendGo           ( );

        //  Member Data.
        Network*      m_pNetwork;
        Synchro       m_eSynchro;
        DWord         m_dwClient;
        Byte          m_bAbort;
        Network::Msg* m_pMsg;
        char          m_strLine[ 64 ];

    private:

};

#endif
