///////////////////////////////////////////////////////////////////////////////
//
//  File:       sdev.h
//
//  Class:      SoundDevice - Abstract
//  
//  Hierarchy:  SoundDevice - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The SoundDevice class serves a base class for a group of classes that
//      are responsible for emulating various sound devices that appeared
//      in classic arcade games (i.e. PSGs, DACs, etc.).
//
//      SoundDevice provides an abstract interface for the game drivers
//      to communicate with these devices.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _sdev_h_
#define _sdev_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repbase.h"
#include "kstring.h"


//  Forward class declarations.
class Sound;


///////////////////////////////////////////////////////////////////////////////
//  SoundDevice Class Definition
///////////////////////////////////////////////////////////////////////////////
class SoundDevice : public RepBase
{
    public:
        
        //  Creation/Deletion.
                 SoundDevice ( const KString& iName );
        virtual ~SoundDevice ( );

        //  Interface.
        virtual void update ( );
        
    protected:

        //  Member Data.
        Sound* m_pSound;

    private:

};

#endif
