///////////////////////////////////////////////////////////////////////////////
//
//  File:    ym3812.cpp
//
//  Class:   YM3812
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is responsible for emulating the Yamaha YM3812 sound chip.
//
//
//      NOTE:  Currently this class is hacked together to provide support
//             only for SoundBlaster compatible cards under DOS.  Eventually,
//             this should be replaced with *real* emulation.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#ifdef DOS
#include <pc.h>
#endif

//  Application Headers.
#include "ym3812.h"
#include "replay.h"
#include "sound.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: YM3812
//
//  Description:
//
//      This is the main constructor for a YM3812 object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
YM3812::YM3812(
    const KString& iName
)
:
    SoundDevice       ( iName ),
    m_bUseOPL         ( Replay::s_instance( ).getSound( )->useOPL( ) )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~YM3812
//
//  Description:
//
//      This is the destructor for a YM3812 object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
YM3812::~YM3812(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the YM3812 class.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
YM3812::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "YM3812" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: setRegister
//
//  Description:
//
//      This member sets the current YM3812 register.
//
//  Parameters:
//
//      bRegister (input)
//          The register of interest.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void       
YM3812::setRegister( 
#ifdef DOS
    const Byte bRegister 
#else
    const Byte /* bRegister is unused */
#endif
)
{
#ifdef DOS
    if( m_bUseOPL )
    {
        outportb( 0x388, bRegister );
    }
#endif
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: writeRegister
//
//  Description:
//
//      This member writes a value to the current YM3812 register.
//
//  Parameters:
//
//      bValue (input)
//          The value to set the register to.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
YM3812::writeRegister( 
#ifdef DOS
    const Byte bValue 
#else
    const Byte /* bValue is unused */
#endif
)
{
#ifdef DOS
    if( m_bUseOPL )
    {
        outportb( 0x389, bValue );
    }
#endif
}


///////////////////////////////////////////////////////////////////////////////
//
//  Function: readRegister
//
//  Description:
//
//      This member returns the value of the current YM3812 register.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The value of the read port.
//
///////////////////////////////////////////////////////////////////////////////
const 
Byte 
YM3812::readRegister( 
)
{
#ifdef DOS
    if( m_bUseOPL )
    {
        return( inportb( 0x389 ) );
    }
#endif
    return( 0x00 );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getStatus
//
//  Description:
//
//      This member returns the status of the YM3812.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      The value of the status port.
//
///////////////////////////////////////////////////////////////////////////////
const 
Byte 
YM3812::getStatus( 
)
{
#ifdef DOS
    if( m_bUseOPL )
    {
        return( inportb( 0x388 ) );
    }
#endif
    return( 0x00 );
}
