///////////////////////////////////////////////////////////////////////////////
//
//  File:    bytemod.cpp
//
//  Class:   ByteModifier
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The ByteModifier class is a simple, lightweight class 
//      which is used for modifying a memory byte.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "bytemod.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ByteModifier
//
//  Description:
//
//      This is the main constructor for a byte modifier object.
//
//  Parameters:
//
//      bLocation (input)
//          The location to the byte that is to be modified.
//
//      bMask (input)
//          The mask to apply to the location.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ByteModifier::ByteModifier(
    Byte* pbLocation,
    Byte  bMask
)
:
    m_pbLocation  ( pbLocation ),
    m_bMask       ( bMask ),
    m_bNotMask    ( ~bMask ),
    m_bReverse    ( FALSE )
{
    //  Check the parameters.
    ASSERT( m_pbLocation != NULL );

    //  A typical byte modifier sets (0x01) the bits in the mask on a set 
    //  unsets (0x00) the bits in the mask on an unset.  However, it will
    //  also allow the reverse.  Here we check whether to reverse or not.
    if( ( *m_pbLocation & m_bMask ) == 0 )
    {
        m_bReverse = FALSE;
    }
    else
    if( ( *m_pbLocation & m_bMask ) == m_bMask )
    {
        m_bReverse = TRUE;
    }
    else
    {
        //  If we arrive here then the mask is made up of some normal bits
        //  and some reversed bits which we don't currently allow.
        ASSERT( FALSE ); 
    }
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~ByteModifier
//
//  Description:
//
//      This is the destructor for a byte modifier object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
ByteModifier::~ByteModifier(
)
{
    //  Nothing to do.
}
