///////////////////////////////////////////////////////////////////////////////
//
//  File:    clip.cpp
//
//  Class:   Clipping
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is a lightweight class that is used to hold a clipping
//      rectangle (min/max X and Y coordinates).
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "clip.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: Clipping
//
//  Description:
//
//      This is the main constructor for a clipping object.
//
//  Parameters:
//
//      nMinX (input)
//          The minimum X coordinate.
//
//      nMaxX (input)
//          The maximum X coordinate.
//
//      nMinY (input)
//          The minimum Y coordinate.
//
//      nMaxY (input)
//          The maximum Y coordinate.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Clipping::Clipping(
    int nMinX /* = 0 */,
    int nMaxX /* = 0 */,
    int nMinY /* = 0 */,
    int nMaxY /* = 0 */
)
:
    m_nMinX ( nMinX ),
    m_nMaxX ( nMaxX ),
    m_nMinY ( nMinY ),
    m_nMaxY ( nMaxY )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Clipping
//
//  Description:
//
//      This is the destructor for a clipping object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Clipping::~Clipping(
)
{
    //  Nothing to do.
}
