///////////////////////////////////////////////////////////////////////////////
//
//  File:       kplist.h
//
//  Class:      KPtrList - Concrete
//  
//  Hierarchy:  KPtrList
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is a lightweight templated pointer list.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _kplist_h_
#define _kplist_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////
//  KPtrList Class Definition
///////////////////////////////////////////////////////////////////////////////
template <class TC> class KPtrList
{
    public:

        //  Creation/Deletion.
                 KPtrList ( int nIncrement = 20 );
        virtual ~KPtrList ( );

        //  List access.
        unsigned int         entries    ( ) const { return( m_nNumItems ); }
        virtual TC*          add        ( TC* pItem );
        TC*                  remove     ( TC* pItem );
        void                 clear      ( );
        void                 shrink     ( unsigned int nEntries );

        TC*&         operator[] ( unsigned int nIdx ) 
            { return( m_ppList[ nIdx ] ); }
        TC*          operator[] ( unsigned int nIdx ) const
            { return( m_ppList[ nIdx ] ); }

    protected:

        //  List manipulation. 
        virtual void growList ( );

      
        //  Member data.
        unsigned int m_nIncrement;
        unsigned int m_nSize;
        unsigned int m_nNumItems;
        TC**         m_ppList;

    private:

};

#endif
