///////////////////////////////////////////////////////////////////////////////
//
//  File:       kpslist.h
//
//  Class:      KPtrSortList - Concrete
//  
//  Hierarchy:  KPtrSortList
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is a lightweight templated pointer list that will remain sorted.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _kpslist_h_
#define _kpslist_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////
#include "kplist.h"



///////////////////////////////////////////////////////////////////////////////
//  KPtrSortList Class Definition
///////////////////////////////////////////////////////////////////////////////
template <class TC> class KPtrSortList : public KPtrList<TC>
{
    public:

        //  Creation/Deletion.
        KPtrSortList ( 
             int ( *pfCompare )( const void*, const void* ),
             int nIncrement = 20 
        );
        virtual ~KPtrSortList ( );

        //  List access.
        virtual TC* add ( TC* pAdd );

    protected:

        //  Member data.
        int ( *m_pfCompare ) ( const void*, const void* );

    private:

};

#endif
