///////////////////////////////////////////////////////////////////////////////
//
//  File:       kstring.h
//
//  Class:      KString - Concrete
//  
//  Hierarchy:  KString
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This is a lightweight String class.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _kstring_h_
#define _kstring_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////



///////////////////////////////////////////////////////////////////////////////
//  RepBase Class Definition
///////////////////////////////////////////////////////////////////////////////
class KString
{
    public:

        //  Creation/Deletion.
                 KString ( );
                 KString ( const KString& ksRef, const int nLength = -1 );
                 KString ( const char* pstrInitial, const int nLength = -1 );
        virtual ~KString ( );

        //  Data access (including conversion operator).
        const char* data     ( ) const { return( m_pstrData ); }
        operator const char* ( ) const { return( m_pstrData ); }
        const int   length   ( ) const { return( m_nLength ); }

        //  Manipulation.
        KString& operator=     ( const KString& ksAssign );
        KString& operator=     ( const char* pstrAssign );
        KString& operator+=    ( const KString& ksAppend );
        KString& operator+=    ( const char* pstrAppend );
        KString& pad           ( const char cPadding, const int nPadLength );

        //  Access.
        char& operator[]  ( const int nIdx ) const;

        //  Comparison.
        int operator==   ( const KString& ksCompare ) const
            { return( !strcmp( this->data( ), ksCompare.data( ) ) ); }
        int operator==   ( const char* pstrCompare ) const
            { return( !strcmp( this->data( ), pstrCompare ) ); }

        //  This will return a "null" KString.
        static const KString& s_getKStringNULL ( ) { return( sm_null ); }

    protected:


    private:

        //  Member Data.
        char* m_pstrData;
        int   m_nLength;

        //  Static Member Data.
        static const KString sm_null;
};

///////////////////////////////////////////////////////////////////////////////
//  Macros.
///////////////////////////////////////////////////////////////////////////////
#define KStringNULL KString::s_getKStringNULL( )


#endif
