///////////////////////////////////////////////////////////////////////////////
//
//  File:    slice.cpp
//
//  Class:   Slice
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      This class is a lightweight class that is used to hold a time
//      slice for a CPU.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "slice.h"


///////////////////////////////////////////////////////////////////////////////
//
//  Function: Slice
//
//  Description:
//
//      This is the main constructor for a slice object.
//
//  Parameters:
//
//      nCPU (input)
//          The index of the CPU the time slice is associated with.
//
//      pCPU (input)
//          The CPU the time slice is associated with.
//
//      nStart (input)
//          The start of the slice in cycles.
//
//      nEnd (input)
//          The end of the slice in cycles.
//
//      nTotal (input)
//          The total number of cycles in a frame for the specified CPU.
//
//      bInterrupt (input)
//          Indicates whether the CPU should be interrupted after the slice.
//
//      bInVBlank (input)
//          Indicates whether the slice is executed during the VBlank or not.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Slice::Slice(
    const int           nCPU,
    CPU*                pCPU,
    const int           nStart,
    const int           nEnd,
    const int           nTotal,
    const unsigned char bInterrupt,
    const unsigned char bInVBlank
)
:
    m_nCPU       ( nCPU ),
    m_pCPU       ( pCPU ),
    m_nStart     ( nStart ),
    m_nEnd       ( nEnd ),
    m_nCycles    ( nEnd - nStart + 1 ),
    m_nTotal     ( nTotal ),
    m_nRemaining ( nTotal - nEnd - 1 ),
    m_bInterrupt ( bInterrupt ),
    m_bInVBlank  ( bInVBlank )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~Slice
//
//  Description:
//
//      This is the destructor for a slice object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
Slice::~Slice(
)
{
    //  Nothing to do.
}
