///////////////////////////////////////////////////////////////////////////////
//
//  File:       slice.h
//
//  Class:      Slice - Concrete
//  
//  Hierarchy:  Slice 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is a lightweight class that is used to hold a time
//      slice for a CPU.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _slice_h_
#define _slice_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  System Headers.
#include <stdlib.h>


//  Forward class declarations.
class CPU;


///////////////////////////////////////////////////////////////////////////////
//  Slice Class Definition
///////////////////////////////////////////////////////////////////////////////
class Slice
{
    public:

        //  Creation/Deletion.
        Slice ( 
            const int           nCPU,
            CPU*                pCPU,
            const int           nStart,
            const int           nEnd,
            const int           nTotal,
            const unsigned char bInterrupt,
            const unsigned char bInVBlank
        );
        virtual ~Slice ( );

        //  Member Data.
        int           m_nCPU;
        CPU*          m_pCPU;
        int           m_nStart;
        int           m_nEnd;
        int           m_nCycles;
        int           m_nTotal;
        int           m_nRemaining;
        unsigned char m_bInterrupt;
        unsigned char m_bInVBlank;

    private:

};

#endif
