///////////////////////////////////////////////////////////////////////////////
//
//  File:       canvasx.h
//
//  Class:      CanvasUnixX - Concrete
//  
//  Hierarchy:  CanvasUnixX - Canvas - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class represents the Display of the Replay application on
//      the Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _canvasx_h_
#define _canvasx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  X Headers.
#include <X11/Xlib.h>
#include <X11/Xutil.h>

//  Application Headers.
#include "canvas.h"
#include "pagex.h"

//  Forward class declarations.
class Bitmap;

///////////////////////////////////////////////////////////////////////////////
//  CanvasUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class CanvasUnixX : public Canvas
{
    public:

        //  Build method.
        static CanvasUnixX* s_build( const KString& iName );

        //  Deletion.
        virtual ~CanvasUnixX ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Page Interface.
        virtual void addPage    (
            const KString& pageName, 
            PageNumber     ePageNumber, 
            DWord          dwWidth, 
            DWord          dwHeight
        );
        virtual void turnPage   ( PageNumber ePageNumber );

        //  Bitmap Interface.
        virtual Bitmap*   createBitmap ( 
            const KString& iName,
            DWord          dwWidth,
            DWord          dwHeight,
            Byte           bForScreen = FALSE
        );
        virtual void      draw ( 
            Bitmap* pBitmap, int32 nX, int32 nY, DWord dwWidth, DWord dwHeight
        );

        //  Palette Interface.
        virtual DWord getNumColours ( ) const;
        virtual void  changeColour  ( 
            DWord dwIndex, DWord dwRed, DWord dwGreen, DWord dwBlue
        );

        //  General Interface.
        virtual Byte update ( );

        //  Unix/X specific interface.
        Display* getDisplay   ( ) const;
        Window   getCurWindow ( ) const;

    protected:

        //  Creation/Initialization.
                     CanvasUnixX ( const KString& iName );
        virtual void init        ( );
        virtual void initCMap    ( );


        //  Member Data.
        Display*         m_pDisplay;
        Screen*          m_pScreen;
        XVisualInfo      m_visual;
        Colormap         m_colourMap;
        GC               m_gc;
        Byte             m_bTrueColour;
        Byte             m_bPrivateCMap;
        Byte             m_bImageScale;
        DWord*           m_pdwPixelList;
        
    private:

};

///////////////////////////////////////////////////////////////////////////////
//  CanvasUnixX Inline Functions.
///////////////////////////////////////////////////////////////////////////////
inline
Display*
CanvasUnixX::getDisplay(
) const
{
    return( m_pDisplay );
}

inline
Window
CanvasUnixX::getCurWindow(
) const
{
    return( ( ( PageUnixX* )m_pPage )->getWindow( ) );
}

#endif
