///////////////////////////////////////////////////////////////////////////////
//
//  File:       clockx.h
//
//  Class:      ClockUnixX - Concrete
//  
//  Hierarchy:  ClockUnixX - Clock - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The ClockUnixX class is a class encapsulating timing on the Unix/X
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _clockx_h_
#define _clockx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "clock.h"
#include "kstring.h"


///////////////////////////////////////////////////////////////////////////////
//  ClockUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class ClockUnixX : public Clock
{
    public:

        //  Creation/Deletion.
                 ClockUnixX ( const KString& iName );
        virtual ~ClockUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  Access.
        virtual DWord getTime ( ) const;

        //  Frame control.
        virtual void frameWait    ( );

    protected:

    private:

};

#endif
