///////////////////////////////////////////////////////////////////////////////
//
//  File:    diskx.cpp
//
//  Class:   DiskUnixX
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The DiskUnixX class is a class encapsulating disk access for the 
//      Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "diskx.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: DiskUnixX
//
//  Description:
//
//      This is the main constructor for a Unix/X disk object.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DiskUnixX::DiskUnixX(
    const KString&  iName
)
:
    Disk    ( iName )
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~DiskUnixX
//
//  Description:
//
//      This is the destructor for a Unix/X disk object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
DiskUnixX::~DiskUnixX(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the disk object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
DiskUnixX::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "DiskUnixX" );

    return( className );
}

