///////////////////////////////////////////////////////////////////////////////
//
//  File:       joyx.h
//
//  Class:      JoystickUnixX - Concrete
//  
//  Hierarchy:  JoystickUnixX - Joystick - 
//                  DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The JoystickUnixX class encapsulates joystick access for the Unix/X
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _joyx_h_
#define _joyx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "joy.h"


///////////////////////////////////////////////////////////////////////////////
//  JoystickUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class JoystickUnixX : public Joystick
{
    public:

        //  Build method.
        static JoystickUnixX* s_build( const KString& iName );

        //  Deletion.
        virtual ~JoystickUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );

    protected:

        //  Creation is protected.  Clients should use a build method.
        JoystickUnixX ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );

    private:

};

#endif
