///////////////////////////////////////////////////////////////////////////////
//
//  File:       keybx.h
//
//  Class:      KeyboardUnixX - Concrete
//  
//  Hierarchy:  KeyboardUnixX - Keyboard - 
//                  DigitalController - Controller - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The Keyboard class encapsulates keyboard access for the Unix/X 
//      platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _keybx_h_
#define _keybx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "keyb.h"
#include "kstring.h"

//  Forward class declarations.
class CanvasUnixX;


///////////////////////////////////////////////////////////////////////////////
//  KeyboardUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class KeyboardUnixX : public Keyboard
{
    public:

        //  Build method.
        static KeyboardUnixX* s_build( const KString& iName );

        //  Deletion.
        virtual ~KeyboardUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;
        virtual Byte           update       ( );
        
    protected:

        //  Creation is protected.  Clients should use a build method.
        KeyboardUnixX ( const KString& iName );

        //  This function should be called from the build method.
        virtual void init ( );


        //  Member Data.
        CanvasUnixX* m_pCanvas;

        //  Static Member Data.
        static const KeyboardKey sm_aKeyCodes[ ];
        static const KeyboardKey sm_aExKeyCodes[ ];

    private:

};

#endif
