///////////////////////////////////////////////////////////////////////////////
//
//  File:    mousex.cpp
//
//  Class:   MouseUnixX
//
//  Author:  Kevin Brisley
//
//  Description:
//
//      The MouseUnixX class encapsulates mouse access for the Unix/X platform.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "mousex.h"



///////////////////////////////////////////////////////////////////////////////
//
//  Function: s_build
//
//  Description:
//
//      This is a factory method to create a Unix/X Mouse object.
//
//  Parameters:
//
//      iName (input)
//          The name of the object.
//
//  Returns:
//
//      A pointer to the new object.
//
///////////////////////////////////////////////////////////////////////////////
MouseUnixX*
MouseUnixX::s_build(
    const KString& iName
)
{
    //  Create the new object.
    MouseUnixX* pThis = new MouseUnixX( iName );

    //  Initialize the new object.
    pThis->init( );

    //  Send back the new mouse.
    return( pThis );
}





///////////////////////////////////////////////////////////////////////////////
//
//  Function: MouseUnixX
//
//  Description:
//
//      This is the main constructor for the Unix/X Mouse object.  This is
//      a protected member.  Clients wishing to create a mouse object should
//      do so through the factory method.
//
//  Parameters:
//
//      iName (input)
//          The instance name of the object. 
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
MouseUnixX::MouseUnixX(
    const KString&  iName
)
:
    Mouse ( iName )
{
    //  All initialization is done in init( ).
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: init
//
//  Description:
//
//      This is called to initialize the mouse object.  By using an init
//      member we get access to virtual functions that we wouldn't in the
//      constructor.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
void
MouseUnixX::init(
)
{
    //  Call the base class.
    Mouse::init( );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: ~MouseUnixX
//
//  Description:
//
//      This is the destructor for a Unix/X mouse object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      Nothing.
//
///////////////////////////////////////////////////////////////////////////////
MouseUnixX::~MouseUnixX(
)
{
    //  Nothing to do.
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: getClassName
//
//  Description:
//
//      This member returns the name of the mouse object.
//
//  Parameters:
//
//      None.
//
//  Returns:
//      The name of the class.
//
///////////////////////////////////////////////////////////////////////////////
const
KString&
MouseUnixX::getClassName(
) const
{
    //  The name of the class.
    static const KString className( "MouseUnixX" );

    return( className );
}



///////////////////////////////////////////////////////////////////////////////
//
//  Function: update
//
//  Description:
//
//      This member should be called periodically to allow the
//      mouse object to update itself.
//
//  Parameters:
//
//      None.
//
//  Returns:
//
//      TRUE  if a mouse state has changed.
//      FALSE if no mouse state has changed.
//
///////////////////////////////////////////////////////////////////////////////
Byte
MouseUnixX::update(
)
{
    return( FALSE );
}
