///////////////////////////////////////////////////////////////////////////////
//
//  File:       repfactx.h
//
//  Class:      ReplayFactoryUnixX - Concrete
//  
//  Hierarchy:  ReplayFactoryUnixX - ReplayFactory - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      This class is a concrete factory that serves as a default factory
//      for those Unix/X platforms that do not have any special processing.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _repfactx_h_
#define _repfactx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "repfact.h"


///////////////////////////////////////////////////////////////////////////////
//  ReplayFactoryUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class ReplayFactoryUnixX : public ReplayFactory
{
    public:

        //  Deletion.
        virtual ~ReplayFactoryUnixX ( );
   
        //  Base overrides.
        virtual const KString& getClassName ( ) const;

    protected:

        //  Creation.
        ReplayFactoryUnixX ( const KString& iName );

        //  Factory methods.
        virtual Canvas*      createCanvas      ( const KString& iName );
        virtual Keyboard*    createKeyboard    ( const KString& iName );
        virtual Joystick*    createJoystick    ( const KString& iName );
        virtual Mouse*       createMouse       ( const KString& iName );
        virtual Sound*       createSound       ( const KString& iName );
        virtual Disk*        createDisk        ( const KString& iName );
        virtual Network*     createNetwork     ( const KString& iName );
        virtual Clock*       createClock       ( const KString& iName );
        virtual GameFactory* createGameFactory ( const KString& iName );
        virtual CPU*         createCPU         (
            const KString&        iName,
            const CPU::CPUType    eCPUType,
            Game*                 pGame,
            AddrSpace*            pSpace,
            const CPU::CPUPurpose ePurpose      = CPU::GAME,
            const Byte            bCONSERVATIVE = FALSE
        );


    private:

        //  Static Member Data.
        static ReplayFactoryUnixX sm_replayFactoryUnixX;
};

#endif
