///////////////////////////////////////////////////////////////////////////////
//
//  File:       soundx.h
//
//  Class:      SoundUnixX - Concrete
//  
//  Hierarchy:  SoundUnixX - Sound - RepBase 
//
//  Author:     Kevin Brisley
//
//  Description:
//
//      The SoundSolaris class is a class encapsulating sound on the Unix/X
//      platform.  Currently there is generic sound support for Unix/X
//      platforms.
//
//
//  Copyright (c) 1997,1998  Kevin Brisley
//  All rights reserved.
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _soundx_h_
#define _soundx_h_

///////////////////////////////////////////////////////////////////////////////
//  Header Files.
///////////////////////////////////////////////////////////////////////////////

//  Application Headers.
#include "sound.h"


///////////////////////////////////////////////////////////////////////////////
//  SoundUnixX Class Definition
///////////////////////////////////////////////////////////////////////////////
class SoundUnixX : public Sound
{
    public:

        //  Creation/Deletion.
                 SoundUnixX ( const KString& iName );
        virtual ~SoundUnixX ( );

        //  Base overrides.
        virtual const KString& getClassName ( ) const;

        //  General Interface.
        virtual Byte update       ( );
        virtual void play         ( Sample* pSample, const Byte bLoop );
        virtual void playStreamed ( Sample* pSample );
        virtual void stop         ( const DWord dwChannel );

    protected:

        //  Utility.
        virtual DWord getNumChannels ( ) const;

        //  Member Data.
        

    private:

};

#endif
