/****************************************************************/
/* anaiistags.h                                                 */
/****************************************************************/
/*                                                              */
/* PANDORA                                                      */
/*                                                              */
/****************************************************************/
/*                                                              */
/* Modification history                                         */
/* ====================                                         */
/* 12-Jan-2013 Add configuration name                           */
/* 30-Nov-2012 Add more statistics tags                         */
/* 08-Aug-2012 Add some tags                                    */
/* 02-Aug-2012 Add Claim/Release interface                      */
/* 30-Jul-2012 Add some interface stuff                         */
/* 18-Jul-2012 Add data1, data2 and data3 for host libusb       */
/* 30-Nov-2011 Transaction counter                              */
/* 28-Sep-2011 Add USBA_HCD                                     */
/* 14-Feb-2008                                                  */
/****************************************************************/
#ifndef ANAIIS_ANAIISTAGS_H_INCLUDED
#define ANAIIS_ANAIISTAGS_H_INCLUDED


/* May change in future */
#define USBA_Parent       (TAG_USER+0x00666000)
#define USBA_Address      (TAG_USER+0x00666001)
#define USBA_HubDesc      (TAG_USER+0x00666002) /* not used */
#define USBA_HIDDesc      (TAG_USER+0x00666003) /* not used */ 
#define USBA_HCD_ID       (TAG_USER+0x00666004) /* */

#define USBA_Attributes   (TAG_USER+0x00666005)
#define USBA_PacketSize   (TAG_USER+0x00666006)
#define USBA_Interval     (TAG_USER+0x00666007)
#define USBA_Buffer       (TAG_USER+0x00666008)

#define USBA_SoftVer      (TAG_USER+0x00666009)

#define USBA_Name         (TAG_USER+0x0066600a)
#define USBA_Base         (TAG_USER+0x0066600b)
#define USBA_State        (TAG_USER+0x0066600c)
#define USBA_Product      (TAG_USER+0x0066600d)
#define USBA_Manufacturer (TAG_USER+0x0066600e)
#define USBA_Serial       (TAG_USER+0x0066600f)
#define USBA_HardVer      (TAG_USER+0x00666010)

#define USBA_Device       (TAG_USER+0x00666011)
#define USBA_Interface    (TAG_USER+0x00666012)

#define USBA_Prefs        (TAG_USER+0x00666013)   

#define USBA_HCD          (TAG_USER+0x00666014)

// device
#define USBA_Data1        (TAG_USER+0x00666020)
#define USBA_Data2        (TAG_USER+0x00666021)
#define USBA_Data3        (TAG_USER+0x00666022)
#define USBA_Data4        (TAG_USER+0x00666024)

#define USBA_Configured   (TAG_USER+0x00666025)
#define USBA_ConfigurationName (TAG_USER+0x0666026)
// interface
#define USBA_Claimed      (TAG_USER+0x00666030)
#define USBA_InterfaceNum (TAG_USER+0x00666031)
#define USBA_AlternateNum (TAG_USER+0x00666032)
//#define USBA_Class        (TAG_USER+0x0666033)
#define USBA_SubClass     (TAG_USER+0x00666034)
#define USBA_Protocol     (TAG_USER+0x00666035)

#define USBA_ResetCnt        (TAG_USER+0x66666665)
#define USBA_MaxTransactions (TAG_USER+0x66666666)
#define USBA_BusWidth        (TAG_USER+0x66666667)
#define USBA_Read8Time       (TAG_USER+0x66666668)
#define USBA_Write8Time      (TAG_USER+0x66666669)
#define USBA_Read16Time      (TAG_USER+0x6666666a)
#define USBA_Write16Time     (TAG_USER+0x6666666b)
#define USBA_Read32Time      (TAG_USER+0x6666666c)
#define USBA_Write32Time     (TAG_USER+0x6666666d)
#define USBA_CCRead8Time     (TAG_USER+0x6666666e)
#define USBA_CCWrite8Time    (TAG_USER+0x6666666f)
#define USBA_CCRead16Time    (TAG_USER+0x66666670)
#define USBA_CCWrite16Time   (TAG_USER+0x66666671)
#define USBA_CCReadBlkTime   (TAG_USER+0x66666672)
#define USBA_CCWriteBlkTime  (TAG_USER+0x66666673)   

#define USBA_ClaimInterfacePtr   (TAG_USER+0x69999998)
#define USBA_ReleaseInterfacePtr (TAG_USER+0x69999999)

#endif
