/****************************************************************/
/* anaiisusb.h                                                  */
/****************************************************************/
/*                                                              */
/* ANAIIS                                                       */
/*                                                              */
/* Some private structures                                      */
/*                                                              */
/****************************************************************/
/*                                                              */
/* Modification history                                         */
/* ====================                                         */
/* 12-Jan-2013 Add configname                                   */
/* 10-Jan-2013 Add langid into device                           */
/* 18-Jul-2012 Add data1, data2 and data3 for host libusb       */
/* 17-Jan-2012 Weak and shutup                                  */
/* 18-Feb-2009 Minimal linked list                              */
/* 15-Aug-2008 Audit                                            */
/* 31-Jul-2008 flags                                            */
/* 08-Apr-2008 claimed                                          */
/* 22-Mar-2008 function interface endpoint                      */
/* 23-Jan-2008 unit instead node                                */
/* 24-Jun-2007 from commands.h file                             */
/****************************************************************/
#ifndef ANAIISUSB_H_INCLUDED
#define ANAIISUSB_H_INCLUDED

#include <exec/types.h>
#include <exec/devices.h>

#include <devices/timer.h>

#include <usb/system.h>

#define ATYPE_STACK         1
#define ATYPE_HARDWARE      3
#define ATYPE_DEVICE        4
#define ATYPE_CONFIG        5
#define ATYPE_CONFIGURATION ATYPE_CONFIG
#define ATYPE_INTERFACE     6
#define ATYPE_ENDPOINT      7

#if 0
/* Tags for AP_GetAttrs(ATYPE_STACK,...) */
#define PA_Dummy             (TAG_USER + 2612)
#define PA_ConfigRead        (PA_Dummy + 0x01)
#define PA_HardwareList      (PA_Dummy + 0x20)
#define PA_ClassList         (PA_Dummy + 0x21)
#define PA_ErrorMsgList      (PA_Dummy + 0x22)
#define PA_GlobalConfig      (PA_Dummy + 0x44)
#define PA_CurrConfigHash    (PA_Dummy + 0x45)
#define PA_SavedConfigHash   (PA_Dummy + 0x46)
#define PA_MemPoolUsage      (PA_Dummy + 0x50)
#define PA_ReleaseVersion    (PA_Dummy + 0x60)
#define PA_OSVersion         (PA_Dummy + 0x61)

/* Tags for AP_GetAttrs(ATYPE_HARDWARE,...) */
#define HA_Dummy             (TAG_USER + 0x2612)
#define HA_DeviceName        (HA_Dummy + 0x10)
#define HA_DeviceUnit        (HA_Dummy + 0x11)
#define HA_ProductName       (HA_Dummy + 0x12)
#define HA_Manufacturer      (HA_Dummy + 0x13)
#define HA_Version           (HA_Dummy + 0x14)
#define HA_Revision          (HA_Dummy + 0x15)
#define HA_Description       (HA_Dummy + 0x16)
#define HA_Copyright         (HA_Dummy + 0x17)
#define HA_DriverVersion     (HA_Dummy + 0x18)
#define HA_DeviceList        (HA_Dummy + 0x20)

/* Tags for AP_GetAttrs(ATYPE_DEVICE,...) */
#define DA_Dummy             (TAG_USER + 42)
#define DA_IsLowspeed        (DA_Dummy + 0x01)
#define DA_IsConnected       (DA_Dummy + 0x02)
#define DA_HasAddress        (DA_Dummy + 0x03)
#define DA_HasDevDesc        (DA_Dummy + 0x04)
#define DA_IsConfigured      (DA_Dummy + 0x05)
#define DA_HasAppBinding     (DA_Dummy + 0x06)
#define DA_IsHighspeed       (DA_Dummy + 0x07)
#define DA_IsDead            (DA_Dummy + 0x08)
#define DA_Config            (DA_Dummy + 0x09)
#define DA_IsSuspended       (DA_Dummy + 0x0a)
#define DA_Address           (DA_Dummy + 0x10)
#define DA_NumConfigs        (DA_Dummy + 0x11)
#define DA_CurrConfig        (DA_Dummy + 0x12)
#define DA_HubDevice         (DA_Dummy + 0x13)
#define DA_UsbVersion        (DA_Dummy + 0x14)
#define DA_Class             (DA_Dummy + 0x15)
#define DA_SubClass          (DA_Dummy + 0x16)
#define DA_Protocol          (DA_Dummy + 0x17)
#define DA_Version           (DA_Dummy + 0x18)
#define DA_VendorID          (DA_Dummy + 0x19)
#define DA_ProductID         (DA_Dummy + 0x1a)
#define DA_Manufacturer      (DA_Dummy + 0x1b)
#define DA_ProductName       (DA_Dummy + 0x1c)
#define DA_SerialNumber      (DA_Dummy + 0x1d)
#define DA_Hardware          (DA_Dummy + 0x1e)
#define DA_Binding           (DA_Dummy + 0x1f)
#define DA_ConfigList        (DA_Dummy + 0x20)
#define DA_LangIDArray       (DA_Dummy + 0x21)
#define DA_CurrLangID        (DA_Dummy + 0x22)
#define DA_BindingClass      (DA_Dummy + 0x23)
#define DA_IDString          (DA_Dummy + 0x24)
#define DA_CloneCount        (DA_Dummy + 0x25)
#define DA_AtHubPortNumber   (DA_Dummy + 0x26)
#define DA_NeedsSplitTrans   (DA_Dummy + 0x27)
#define DA_OrigProductName   (DA_Dummy + 0x28)
#define DA_DescriptorList    (DA_Dummy + 0x29)
#define DA_MaxPktSize0       (DA_Dummy + 0x2a)
#define DA_HubThinkTime      (DA_Dummy + 0x2b)
#define DA_PowerSupply       (DA_Dummy + 0x30)
#define DA_PowerDrained      (DA_Dummy + 0x31)
#define DA_LowPower          (DA_Dummy + 0x32)
#define DA_InhibitPopup      (DA_Dummy + 0x40)
#define DA_IsNewToMe         (DA_Dummy + 0x41)
#define DA_InhibitClassBind  (DA_Dummy + 0x42)
#define DA_OverridePowerInfo (DA_Dummy + 0x43)

/* Tags for AP_GetAttrs(ATYPE_CONFIG,...) */
#define CA_Dummy             (TAG_USER + 23)
#define CA_Attrs             (CA_Dummy + 0x01)
#define CA_SelfPowered       (CA_Dummy + 0x02)
#define CA_RemoteWakeup      (CA_Dummy + 0x03)
#define CA_ConfigNum         (CA_Dummy + 0x10)
#define CA_MaxPower          (CA_Dummy + 0x11)
#define CA_ConfigName        (CA_Dummy + 0x12)
#define CA_NumInterfaces     (CA_Dummy + 0x13)
#define CA_Device            (CA_Dummy + 0x14)
#define CA_InterfaceList     (CA_Dummy + 0x20)

/* Tags for AP_GetAttrs(ATYPE_INTERFACE,...) */
#define IFA_Dummy            (TAG_USER + 4711)
#define IFA_InterfaceNum     (IFA_Dummy + 0x10)
#define IFA_AlternateNum     (IFA_Dummy + 0x11)
#define IFA_Class            (IFA_Dummy + 0x12)
#define IFA_SubClass         (IFA_Dummy + 0x13)
#define IFA_Protocol         (IFA_Dummy + 0x14)
#define IFA_InterfaceName    (IFA_Dummy + 0x15)
#define IFA_Config           (IFA_Dummy + 0x16)
#define IFA_Binding          (IFA_Dummy + 0x17)
#define IFA_NumEndpoints     (IFA_Dummy + 0x18)
#define IFA_BindingClass     (IFA_Dummy + 0x19)
#define IFA_IDString         (IFA_Dummy + 0x1a)
#define IFA_EndpointList     (IFA_Dummy + 0x20)
#define IFA_AlternateIfList  (IFA_Dummy + 0x21)

/* Tags for AP_GetAttrs(ATYPE_ENDPOINT,...) */
#define EA_Dummy             (TAG_USER + 1138)
#define EA_IsIn              (EA_Dummy + 0x01)
#define EA_EndpointNum       (EA_Dummy + 0x10)
#define EA_TransferType      (EA_Dummy + 0x11)
#define EA_MaxPktSize        (EA_Dummy + 0x12)
#define EA_Interval          (EA_Dummy + 0x13)
#define EA_Interface         (EA_Dummy + 0x14)
#define EA_NumTransMuFrame   (EA_Dummy + 0x15)
#define EA_SyncType          (EA_Dummy + 0x16)
#define EA_UsageType         (EA_Dummy + 0x17)
#endif

/****************************************************************/
/* device                                                       */
/*   interface                                                  */
/*     endpoint                                                 */
/****************************************************************/

struct USBEndPoint
{
  struct USBEndPoint  *next ;     /* node */
  struct USBEndPoint  *pred ;     /* */
  UBYTE  type ;                   /* */
  BYTE   pri ;                    /* */
  struct USBDevice    *devowner ; /* */
  struct USBInterface *intowner ; /* */
  UBYTE address ;                 /* endpoint address (0..15) */
  UBYTE attributes ;              /* INT, IN, OUT, BLUK, ISO */
  UWORD maxpacketsize ;           /* buffer size */
  UBYTE interval ;                /* polling delay */
  UBYTE data1 ;                   /* ugly thing */
  UBYTE pad ;
  UBYTE valid ;                   /* */
  APTR  buffer ;                  /* */
  APTR  buffer2 ;                 /* */

  struct Interrupt   *interrupt ;

  ULONG datacount ;               /* audit : amount of data */
  struct timeval datatime ;       /* audit : time */
  ULONG dataerrors ;              /* audit : error count */
} ;

struct USBInterface
{
  struct USBInterface *next ;
  struct USBInterface *pred ;
  UBYTE  type ;
  BYTE   pri ;
  struct USBDevice    *devowner ;
  struct USBBusIntDsc desc ;
  ULONG  flags ;
  APTR   uni_interfacename ;
  char * interfacename ;
  APTR   devicedata ;
  struct USBEndPoint  *endpoint ;

  struct SignalSemaphore locksema ;

  struct MsgPort *port ;
  APTR   fdifc ;
} ;

struct USBDevice
{
  struct Unit unit ; 
  struct Hardware *hwbase ; /* assigned at boot time for low level hardware use only */
  UBYTE  address ;    /* device address */
  UBYTE  speed ;      /* device speed low or high */
  UBYTE  configured ; /* device is configured */
  UBYTE  nadata1 ;    /* ugly pad */

  ULONG  flags ;      /* device has got a driver */
  LONG   lasterror ;

  struct USBBusDevDsc dev ;
  struct USBBusCfgDsc cfg ;

  APTR configuration ;

  char *devicename ;
  APTR devicedata ;

  struct USBEndPoint ep0 ;
  
  ULONG langid ;

  APTR uni_vendorname ;
  APTR uni_productname ;
  APTR uni_serialname ;

  APTR uni_configurationname ;

  struct USBInterface *interface ; /* interface list */
  
  struct USBDevice *parent ; /* the hub */
  ULONG portnum ;            /* the port relative to the hub */

  struct SignalSemaphore locksema ;

  struct MsgPort *port ;
  APTR   fdfkt ;

  ULONG data1 ; /**/
  ULONG data2 ; /**/
  ULONG data3 ; /**/
} ;

/* USBDevice and USBInterface flags content */
#define FLAGS_LOCKED  1
#define FLAGS_CLAIMED 2
#define FLAGS_WEAK    4
#define FLAGS_SHUTUP  8

/* Flags after USBIOReq */
#define USB_IOF_TRACE    0x80 /* 10000000 */
#define USB_IOF_RETRYMSK 0x70 /* 01110000 */
#define USB_IOS_RETRYSFT 4
#define USB_IOF_PHASEMSK 0x0c /* 00001100 */
#define USB_IOS_PHASESFT 2
#define USB_IOF_QUICK    0x01 /* 00000001 */

#define USB_SETUP_PHASE  0
#define USB_DATA_PHASE   1
#define USB_STATUS_PHASE 2

#endif
