/****************************************************************************/
/*                               hostusb.h                                  */
/****************************************************************************/
/* libusb interface for WinUAE                                              */
/****************************************************************************/
/* Modification history                                                     */
/* ====================                                                     */
/* 16-Oct-2012 Add libusbx functions                                        */
/* 01-Aug-2012 Add all libusb functions                                     */
/* 21-Jun-2012 Creation                                                     */
/****************************************************************************/

#ifdef HOSTUSB_EXPORTS
#define HOSTUSB_API __declspec(dllexport)
#else
#define HOSTUSB_API __declspec(dllimport)
#endif

/* some structs      */
#include "lusb0_usb.h"
#include "libusb.h"

/* Microsoft stuff... */
class HOSTUSB_API Chostusb
{
public:
  Chostusb(void) ;
  ~Chostusb(void) ;
} ;

/* this represents the stackframe... */
struct StackFrame
{
  unsigned long d1 ;
  unsigned long d2 ;
  unsigned long d3 ;
  unsigned long d4 ;
  unsigned long d5 ;
  unsigned long d6 ;
  unsigned long d7 ;
  unsigned long a1 ;
  unsigned long a2 ;
  unsigned long a3 ;
  unsigned long a4 ;
  unsigned long a5 ;
  unsigned long a6 ;
  unsigned long a7 ;
} ;

#if 1
// tests!!
extern "C" HOSTUSB_API int func1(unsigned long *a) ;
extern "C" HOSTUSB_API int func2(unsigned long *a) ;
#endif

/* General things */
extern "C" HOSTUSB_API void HostDebug(unsigned long *a) ;
extern "C" HOSTUSB_API void HostNoDebug(void) ;
extern "C" HOSTUSB_API int HostOpen(unsigned long *a) ;
extern "C" HOSTUSB_API int HostFOpen(unsigned long *a) ;
extern "C" HOSTUSB_API int HostClose(unsigned long *a) ;
extern "C" HOSTUSB_API int HostRead(unsigned long *a) ;
extern "C" HOSTUSB_API int HostWrite(unsigned long *a) ;
extern "C" HOSTUSB_API int HostSeek(unsigned long *a) ;
extern "C" HOSTUSB_API void HostCopyMem(unsigned long *a) ;

/* libusb functions */
extern "C" HOSTUSB_API int usb_init(unsigned long *a) ;
extern "C" HOSTUSB_API void usb_set_debug(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_find_busses(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_find_devices(unsigned long *a) ;
extern "C" HOSTUSB_API struct usb_device * usb_device(unsigned long *a) ;
extern "C" HOSTUSB_API struct usb_bus * usb_get_busses(unsigned long *a) ;
extern "C" HOSTUSB_API struct usb_bus * usb_get_next_bus(unsigned long *a) ;
extern "C" HOSTUSB_API const struct usb_version * usb_get_version(unsigned long *a) ;
extern "C" HOSTUSB_API void usb_get_version2(unsigned long *a) ;

extern "C" HOSTUSB_API usb_dev_handle * usb_open(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_close(unsigned long *a) ;

extern "C" HOSTUSB_API int usb_get_string(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_get_string2(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_get_string_simple(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_get_descriptor_by_endpoint(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_get_descriptor(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_bulk_write(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_bulk_read(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_interrupt_write(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_interrupt_read(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_control_msg(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_set_configuration(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_claim_interface(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_release_interface(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_set_altinterface(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_resetep(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_clear_halt(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_reset(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_reset_ex(unsigned long *a) ;
extern "C" HOSTUSB_API char *usb_strerror(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_install_service_np(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_uninstall_service_np(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_install_driver_np(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_isochronous_setup_async(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_bulk_setup_async(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_interrupt_setup_async(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_submit_async(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_reap_async(unsigned long *a) ;
extern "C" HOSTUSB_API int usb_free_async(unsigned long *a) ;


/* libusbx functions */
extern "C" HOSTUSB_API int libusb_init(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_exit(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_set_debug(unsigned long *a) ;
extern "C" HOSTUSB_API const struct libusb_version * libusb_get_version(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_has_capability(unsigned long *a);
extern "C" HOSTUSB_API const char * libusb_error_name(unsigned long *a) ;
extern "C" HOSTUSB_API ssize_t libusb_get_device_list(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_free_device_list(unsigned long *a) ;
extern "C" HOSTUSB_API libusb_device * libusb_ref_device(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_unref_device(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_configuration(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_device_descriptor(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_active_config_descriptor(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_config_descriptor(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_config_descriptor_by_value(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_free_config_descriptor(unsigned long *a) ;
extern "C" HOSTUSB_API uint8_t libusb_get_bus_number(unsigned long *a) ;
extern "C" HOSTUSB_API uint8_t libusb_get_port_number(unsigned long *a) ;
extern "C" HOSTUSB_API libusb_device * libusb_get_parent(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_port_path(unsigned long *a) ;
extern "C" HOSTUSB_API uint8_t libusb_get_device_address(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_device_speed(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_max_packet_size(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_get_max_iso_packet_size(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_open(unsigned long *a) ;
extern "C" HOSTUSB_API void libusb_close(unsigned long *a) ;
extern "C" HOSTUSB_API libusb_device * libusb_get_device(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_set_configuration(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_claim_interface(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_release_interface(unsigned long *a) ;
extern "C" HOSTUSB_API libusb_device_handle * libusb_open_device_with_vid_pid(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_set_interface_alt_setting(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_clear_halt(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_reset_device(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_kernel_driver_active(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_detach_kernel_driver(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_attach_kernel_driver(unsigned long *a) ;

extern "C" HOSTUSB_API int libusb_control_transfer(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_bulk_transfer(unsigned long *a) ;
extern "C" HOSTUSB_API int libusb_interrupt_transfer(unsigned long *a) ;

extern "C" HOSTUSB_API int libusb_get_descriptor(unsigned long *a) ;
