/****************************************************************/
/* anaiis_private_protos.h                                      */
/****************************************************************/
/*                                                              */
/*                                                              */
/*                                                              */
/****************************************************************/
/*                                                              */
/* Modification history                                         */
/* ====================                                         */
/* 14-Apr-2012 Change Names for GetJoyPortAttrs                 */
/* 01-Mar-2012 Add analogue joysticks support                   */
/* 30-Mar-2011 Add 64 bit routines                              */
/* 28-Dec-2009 Old lowlevel access                              */
/* 09-Feb-2009 timer                                            */
/* 20-Jan-2009 separate includes                                */
/* 10-Jan-2009                                                  */
/****************************************************************/
#ifndef ANAIIS_PRIVATE_PROTOS_H_INCLUDED
#define ANAIIS_PRIVATE_PROTOS_H_INCLUDED

#include <usb/system.h>
#include <usb/usb.h>

#include "anaiisusb.h"

/* Prototypes */
struct USBDevice * AP_AllocUSBDevice(struct Hardware *hw,struct USBInterface *hub,struct TagItem *taglist) ;
void AP_FreeUSBDevice(struct USBDevice *d) ;
struct USBInterface * AP_AllocUSBInterface(struct USBDevice *d) ;
void AP_FreeUSBInterfaces(struct USBDevice *d) ;
struct USBEndPoint * AP_AllocUSBEndPoint(struct USBInterface *i) ;
void AP_FreeUSBEndPoints(struct USBInterface *i) ;
struct USBDevice * AP_GetNextUSBDevice(struct USBDevice *d) ;
struct USBInterface * AP_GetNextUSBDeviceInterface(struct USBDevice *d, struct USBInterface *i) ;
struct USBInterface * AP_GetNextUSBInterface(struct USBInterface *i) ;
void AP_RegisterUSBEP(struct USBEndPoint *ep) ;
void AP_UnregisterUSBEP(struct USBEndPoint *ep) ;
struct USBEndPoint * AP_GetNextUSBEP(struct USBEndPoint *ep) ;
struct Node *AP_GetNextHCD(struct Node *hcd) ;
void AP_GetAttrsA(ULONG type, struct Node *obj, struct TagItem *taglist) ;
void AP_GetAttrs(ULONG type, struct Node *, ULONG tags, ... ) ;
void AP_SetAttrsA(ULONG type, struct Node *obj, struct TagItem *taglist) ;
void AP_SetAttrs(ULONG type, struct Node *, ULONG tags, ... ) ;
void AP_NotifyUSBDevice(struct USBDevice *d, ULONG msgtype) ;
void AP_NotifyUSBInterface(struct USBInterface *i, ULONG msgtype) ;

APTR AP_CreateIORequest(struct MsgPort *port, ULONG size) ;
void AP_DeleteIORequest(APTR iorequest) ;
struct MsgPort * AP_CreateMsgPort(void) ;
void AP_DeleteMsgPort(struct MsgPort *port) ;
APTR AP_AllocVec(ULONG byteSize, ULONG requirements) ;
void AP_FreeVec(APTR memoryBlock) ;
void AP_CopyMem(APTR source, APTR dest, ULONG size) ;
void AP_CopyMemQuick(APTR source, APTR dest, ULONG size) ;
void AP_ColdReboot(void) ;
void AP_InitSemaphore(struct SignalSemaphore *sigSem) ;
void AP_ObtainSemaphore(struct SignalSemaphore *sigSem) ;
void AP_ReleaseSemaphore(struct SignalSemaphore *sigSem) ;
BOOL AP_AttemptSemaphore(struct SignalSemaphore *sigSem) ;

struct timerequest * AP_CreateTimer(void) ;
void AP_DeleteTimer(struct timerequest *tr) ;
void AP_USBDelay(ULONG micros) ;
void AP_GetSysTime(struct timeval *dest) ;
void AP_AddTime(struct timeval *dest, struct timeval *src) ;
void AP_SubTime(struct timeval *dest, struct timeval *src) ;
LONG AP_CmpTime(struct timeval *dest, struct timeval *src) ;

struct TagItem * AP_NextTagItem(struct TagItem **tagListPtr) ;

void AP_GetJoyPortAttrsA(ULONG portNumber, struct TagItem *tagList) ;
void AP_SetJoyPortAttrsA(ULONG portNumber, struct TagItem *tagList) ;
void AP_SetKey(ULONG value ) ;
void AP_WriteJoyPort(ULONG portNumber, ULONG value) ;
ULONG AP_GetKey(void) ;
ULONG AP_ReadJoyPort(ULONG portNumber) ;
ULONG AP_OldGetKey(void) ;
ULONG AP_OldReadJoyPort(ULONG portNumber) ;

void AP_StrC(struct USBBusDscHead *strdsc, UBYTE *str) ;
void AP_CStr(struct USBBusDscHead *strdsc, UBYTE *str) ;
struct USBBusDscHead * AP_DupStr(struct USBBusDscHead *dsc) ;
void AP_FreeStr(struct USBBusDscHead *dsc) ;

void AP_Add64(uint64 *src, uint64 *dst) ;
void AP_Sub64(uint64 *src, uint64 *dst) ;
void AP_u64toa(uint64 *num, UBYTE *str) ;
void AP_LShift64(uint64 *a, UBYTE shift) ;
void AP_RShift64(uint64 *a, UBYTE shift) ;
LONG AP_Cmp64(uint64 *a, uint64 *b) ;
void AP_Divu64(uint64 *dividend, uint64 *divisor, uint64 *quotient, uint64 *remainder) ;
void AP_Mulu64(uint64 *a, uint64 *b, uint64 *axb) ;
#endif
