


extern __asm ULONG DLL_LoadLibrary(register __a0 UBYTE* dllname) ;
extern __asm void DLL_FreeLibrary(register __d1 ULONG dllhandle) ;
extern __asm ULONG DLL_GetProcAddress(register __d1 ULONG dllhandle, register __a0 UBYTE *name) ;
extern __asm ULONG DLL_Exec(register __a0 ULONG addr) ;
extern __asm ULONG DLL_GetMemoryOffset(void) ;
extern __asm ULONG DLL_GetChipOffset(void) ;

extern void __asm HostCopyMem(register __d1 char *src, register __d2 char *dst, register __d3 ULONG size) ;
 
ULONG DLLOpen(UBYTE *name, ULONG accessMode) ;
ULONG DLLFOpen(UBYTE *name, UBYTE *mode) ;
void DLLClose(ULONG file) ;
ULONG DLLRead(ULONG file, UBYTE *buffer, ULONG length) ;
ULONG DLLWrite(ULONG file, UBYTE *buffer, ULONG length) ;
ULONG DLLSeek(ULONG file, ULONG offset, ULONG pos) ;
ULONG DLLInit(void) ;
void DLLFree(ULONG handle) ;

void SetDebug(int) ;


#define LIBUSB_PATH_MAX 512

typedef unsigned long usb_dev_handle ;

/* Device descriptor */
struct usb_device_descriptor
{
    unsigned char  bLength;
    unsigned char  bDescriptorType;
    unsigned short bcdUSB;
    unsigned char  bDeviceClass;
    unsigned char  bDeviceSubClass;
    unsigned char  bDeviceProtocol;
    unsigned char  bMaxPacketSize0;
    unsigned short idVendor;
    unsigned short idProduct;
    unsigned short bcdDevice;
    unsigned char  iManufacturer;
    unsigned char  iProduct;
    unsigned char  iSerialNumber;
    unsigned char  bNumConfigurations;
};

struct usb_config_descriptor
{
  ULONG nada ;
} ;

struct usb_device
{
    struct usb_device *next, *prev;

    char filename[LIBUSB_PATH_MAX];

    struct usb_bus *bus;

    struct usb_device_descriptor descriptor;
    struct usb_config_descriptor *config;

    void *dev;		/* Darwin support */

    unsigned char devnum;

    unsigned char num_children;
    struct usb_device **children;
} ;

struct usb_bus
{
    struct usb_bus *next, *prev;

    char dirname[LIBUSB_PATH_MAX];

    struct usb_device *devices;
    unsigned long location;

    struct usb_device *root_dev;
} ;

/* libusb win32 interface (not good for bulk) */
extern long __asm usb_init(void) ;
extern int __asm usb_find_busses(void) ;
extern int __asm usb_find_devices(void) ;
extern struct usb_bus * __asm usb_get_busses(void) ;
extern ULONG __asm usb_open(register __d1 ULONG dev) ;
extern void __asm usb_close(register __d1 ULONG udev) ;
extern ULONG __asm usb_get_version(void) ;
extern int __asm usb_bulk_write(
register __d1 ULONG dev,
register __d2 ULONG ep,
register __d3 ULONG bytes,
register __d4 ULONG size,
register __d5 ULONG timeout) ;
extern int __asm usb_bulk_read(
register __d1 ULONG dev,
register __d2 ULONG ep,
register __d3 ULONG bytes,
register __d4 ULONG size,
register __d5 ULONG timeout) ;
extern int __asm usb_interrupt_write(
register __d1 ULONG dev,
register __d2 ULONG ep,
register __d3 ULONG bytes,
register __d4 ULONG size,
register __d5 ULONG timeout) ;
extern int __asm usb_interrupt_read(
register __d1 ULONG dev,
register __d2 ULONG ep,
register __d3 ULONG bytes,
register __d4 ULONG size,
register __d5 ULONG timeout) ;
extern int __asm usb_control_msg(
register __d1 ULONG udev,
register __d2 ULONG requesttype,
register __d3 ULONG request,
register __d4 ULONG value,
register __d5 ULONG index,
register __d6 ULONG bytes,
register __d7 ULONG size,
register __a1 ULONG timeout) ;

extern int __asm usb_set_configuration(
register __d1 ULONG udev,
register __d2 int config) ;

extern int __asm usb_claim_interface(
register __d1 ULONG udev,
register __d2 int interface) ;

extern int __asm usb_release_interface(
register __d1 ULONG udev,
register __d2 int interface) ;

extern int __asm usb_set_altinterface(
register __d1 ULONG udev,
register __d2 int alternate) ;

extern int __asm usb_resetep(
register __d1 ULONG udev,
register __d2 int ep) ;

extern int __asm usb_clear_halt(
register __d1 ULONG udev,
register __d2 int ep) ;


/* libusbx */
extern LONG __asm libusb_init(register __d1 ULONG ctx) ;
extern LONG __asm libusb_exit(register __d1 ULONG ctx) ;
extern ULONG * __asm libusb_get_version(void) ;
extern ULONG * __asm libusb_error_name(register __d1 ULONG errcode) ;
extern int __asm libusb_get_device_list(register __d1 ULONG ctx, register __d2 ULONG list) ;
extern void __asm libusb_free_device_list(register __d1 ULONG list, register __d2 ULONG n) ;

extern ULONG __asm libusb_get_device_descriptor(
register __d1 ULONG /*libusb_device * */ dev,
register __d2 ULONG /*struct libusb_device_descriptor * */ desc
) ;
extern ULONG __asm libusb_get_bus_number(register __d1 ULONG dev) ;
extern ULONG __asm libusb_get_port_number(register __d1 ULONG dev) ;
extern ULONG __asm libusb_get_parent(register __d1 ULONG dev) ;
extern ULONG __asm libusb_get_device_address(register __d1 ULONG dev) ;
extern ULONG __asm libusb_get_device_speed(register __d1 ULONG dev) ;
extern int  __asm libusb_open(register __d1 ULONG dev, register __d2 ULONG handleptr) ;
extern void __asm libusb_close(register __d1 ULONG handle) ;
extern int __asm libusb_claim_interface(register __d1 ULONG handle, register __d2 ULONG interface) ;
extern int __asm libusb_release_interface(register __d1 ULONG handle, register __d2 ULONG interface) ;

extern int __asm libusb_set_interface_alt_setting(register __d1 ULONG handle, register __d2 ULONG interface_number, register __d3 ULONG alternate_setting) ;
extern int __asm libusb_clear_halt(register __d1 ULONG handle, register __d2 ULONG endpoint) ;

extern int __asm libusb_control_transfer(
register __d1 ULONG dev,
register __d2 ULONG requesttype,
register __d3 ULONG request,
register __d4 ULONG value,
register __d5 ULONG index,
register __d6 ULONG bytes,
register __d7 ULONG size,
register __a1 ULONG timeout) ;

extern int __asm libusb_bulk_transfer(
register __d1 ULONG dev,
register __d2 ULONG ep,
register __d3 ULONG bytes,
register __d4 ULONG size,
register __d5 ULONG psize,
register __d6 ULONG timeout) ;

extern int __asm libusb_interrupt_transfer(
register __d1 ULONG dev,
register __d2 ULONG endpoint,
register __d3 ULONG data,
register __d4 ULONG length,
register __d5 ULONG actual_length,
register __d6 ULONG timeout);

