/** @file win_ledbox.h

	HITACHI BASIC MASTER LEVEL3 Mark5 / MB-S1 Emulator 'EmuB-6892/EmuB-S1'
	Skelton for retropc emulator

	@author Sasaji
	@date   2015.12.21 -

	@brief [ led box ]
*/

#if !(defined(USE_SDL2) && defined(USE_SDL2_LEDBOX))

#ifndef WIN_LEDBOX_H
#define WIN_LEDBOX_H

#include "../ledbox.h"
#include "../../depend.h"
#include <windows.h>
#include "../../osd/windows/win_d2d.h"
#include "../../res/resource.h"

#define NO_TITLEBAR

/**
	@brief LedBox is the window that display the access indicator outside the main window.
*/
class LedBox : public LedBoxBase
{
private:
	HWND		hLedBox;
	HINSTANCE	hInstance;
	HWND		hParent;

#if defined(USE_SDL) || defined(USE_SDL2) || defined(USE_WX)
	HDC         hSufDC;
	HBITMAP     hSufBmp;
	BITMAPINFO  bmiSuf;
#endif

	void show_dialog();
	void move_in_place(int place);
	void need_update_dialog();

#ifdef NO_TITLEBAR
	void mouse_move(HWND, const POINT &, const LPARAM &);
#else
	void set_dist(HWND);
#endif
	void adjust_dialog_size(HWND);
	void activate_parent_window(HWND);
	void update_dialog(HDC);

	static INT_PTR CALLBACK LedBoxProc(HWND, UINT, WPARAM, LPARAM);

	// Direct2D
	CD2DHwndRender mD2DRender;
	CD2DSurface mD2DSurface;
	bool create_d2d_surface();
	void release_d2d_surface();
	void draw_d2d_render();

public:
	LedBox();
	~LedBox();

	void SetHandle(HINSTANCE hInst, HWND hWnd);
	void CreateDialogBox();
	void Move();
};

#endif /* WIN_LEDBOX_H */

#endif /* !(USE_SDL2 && USE_SDL2_LEDBOX) */
