/** @file gtk_input.h

	Skelton for retropc emulator
	GTK+ + SDL edition

	@author Sasaji
	@date	2017.01.21

	@brief [ gtk input ]

*/

#ifndef GTK_INPUT_H
#define GTK_INPUT_H

#include "../../emu.h"
#include "../../vm/vm.h"
#include "../../keycode.h"

#if defined(USE_GTK)

/* 0x00xx */
const uint8_t gtkcode2keycode1[128] = {
	/* 0x00 - 0x0f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x10 - 0x1f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x20 - 0x2f */
	KEYCODE_SPACE,
	KEYCODE_1,
	KEYCODE_2,
	KEYCODE_3,
	KEYCODE_4,
	KEYCODE_5,
	KEYCODE_6,
	KEYCODE_7,
	KEYCODE_8,
	KEYCODE_9,
	KEYCODE_COLON,
	KEYCODE_SEMICOLON,
	KEYCODE_COMMA,
	KEYCODE_MINUS,
	KEYCODE_PERIOD,
	KEYCODE_SLASH,
	/* 0x30 - 0x3f */
	0,	// KEYCODE_0,
	KEYCODE_1,
	KEYCODE_2,
	KEYCODE_3,
	KEYCODE_4,
	KEYCODE_5,
	KEYCODE_6,
	KEYCODE_7,
	KEYCODE_8,
	KEYCODE_9,
	KEYCODE_COLON,
	KEYCODE_SEMICOLON,
	KEYCODE_COMMA,
	KEYCODE_MINUS,
	KEYCODE_PERIOD,
	KEYCODE_SLASH,
	/* 0x40 - 0x4f */
	KEYCODE_AT,
	KEYCODE_A,
	KEYCODE_B,
	KEYCODE_C,
	KEYCODE_D,
	KEYCODE_E,
	KEYCODE_F,
	KEYCODE_G,
	KEYCODE_H,
	KEYCODE_I,
	KEYCODE_J,
	KEYCODE_K,
	KEYCODE_L,
	KEYCODE_M,
	KEYCODE_N,
	KEYCODE_O,
	/* 0x50 - 0x5f */
	KEYCODE_P,
	KEYCODE_Q,
	KEYCODE_R,
	KEYCODE_S,
	KEYCODE_T,
	KEYCODE_U,
	KEYCODE_V,
	KEYCODE_W,
	KEYCODE_X,
	KEYCODE_Y,
	KEYCODE_Z,
	KEYCODE_LBRACKET,
	0,	// KEYCODE_BACKSLASH,
	KEYCODE_RBRACKET,
	0,	// KEYCODE_CARET,
	0,	// KEYCODE_UNDERSCORE,
	/* 0x60 - 0x6f */
	KEYCODE_AT,
	KEYCODE_A,
	KEYCODE_B,
	KEYCODE_C,
	KEYCODE_D,
	KEYCODE_E,
	KEYCODE_F,
	KEYCODE_G,
	KEYCODE_H,
	KEYCODE_I,
	KEYCODE_J,
	KEYCODE_K,
	KEYCODE_L,
	KEYCODE_M,
	KEYCODE_N,
	KEYCODE_O,
	/* 0x70 - 0x7f */
	KEYCODE_P,
	KEYCODE_Q,
	KEYCODE_R,
	KEYCODE_S,
	KEYCODE_T,
	KEYCODE_U,
	KEYCODE_V,
	KEYCODE_W,
	KEYCODE_X,
	KEYCODE_Y,
	KEYCODE_Z,
	KEYCODE_LBRACKET,
	0,	// KEYCODE_BACKSLASH,
	KEYCODE_RBRACKET,
	0,	// KEYCODE_CARET,
	0	// KEYCODE_UNDERSCORE
};

/* 0xffxx */
const uint8_t gtkcode2keycode2[256] = {
	/* 0x00 - 0x0f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_BACKSPACE,
	KEYCODE_TAB,
	0,
	KEYCODE_CLEAR,
	0,
	KEYCODE_RETURN,
	0,
	0,
	/* 0x10 - 0x1f */
	0,
	0,
	0,
	KEYCODE_PAUSE,
	KEYCODE_SCROLLLOCK,
	KEYCODE_SYSREQ,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_ESCAPE,
	0,
	0,
	0,
	0,
	/* 0x20 - 0x2f */
	0, // KEYCODE_MULTIKEY,
	KEYCODE_GRAVE,	// KEYCODE_KANJI, 
	KEYCODE_MUHENKAN,
	KEYCODE_HENKAN,
	KEYCODE_KATAHIRA,	// KEYCODE_ROMAJI,
	KEYCODE_KATAHIRA,	// KEYCODE_HIRAGANA,
	KEYCODE_KATAHIRA,	// KEYCODE_KATAKANA,
	KEYCODE_KATAHIRA,
	KEYCODE_GRAVE,	// KEYCODE_ZENKAKU,
	KEYCODE_GRAVE,	// KEYCODE_HANKAKU,
	KEYCODE_GRAVE,	// KEYCODE_ZENHAN,
	0, // KEYCODE_TOUROKU,
	0,
	0,
	0,
	0,
	/* 0x30 - 0x3f */
	KEYCODE_CAPSLOCK,	// EISU_TOGGLE
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x40 - 0x4f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x50 - 0x5f */
	KEYCODE_HOME,
	KEYCODE_LEFT,
	KEYCODE_UP,
	KEYCODE_RIGHT,
	KEYCODE_DOWN,
	KEYCODE_PAGEUP,
	KEYCODE_PAGEDOWN,
	KEYCODE_END,
	0, // KEYCODE_BEGIN,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0x60 - 0x6f */
	KEYCODE_SELECT,
	KEYCODE_PRINT,
	0, // KEYCODE_EXECUTE,
	KEYCODE_INSERT,
	0,
	KEYCODE_UNDO,
	0, // KEYCODE_REDO,
	KEYCODE_MENU,
	0, // KEYCODE_CANCEL,
	KEYCODE_HELP,
	KEYCODE_PAUSE, // KEYCODE_BREAK,
	0,
	0,
	0,
	0,
	0,
	/* 0x70 - 0x7f */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_NUMLOCK,
	/* 0x80 - 0x8f */
	0, // KEYCODE_KP_SPECE,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0, // KEYCODE_KP_TAB,
	0,
	0,
	0,
	KEYCODE_KP_ENTER,
	0,
	0,
	/* 0x90 - 0x9f */
	0,
	0,
	0,
	0,
	0,
	KEYCODE_KP_7,	// KEYCODE_KP_HOME
	KEYCODE_KP_4,	// KEYCODE_KP_LEFT
	KEYCODE_KP_8,	// KEYCODE_KP_UP
	KEYCODE_KP_6,	// KEYCODE_KP_RIGHT
	KEYCODE_KP_2,	// KEYCODE_KP_DOWN
	KEYCODE_KP_9,	// KEYCODE_KP_PAGEUP
	KEYCODE_KP_3,	// KEYCODE_KP_PAGEDOWN
	KEYCODE_KP_1,	// KEYCODE_KP_END
	0,
	KEYCODE_KP_0,	// KEYCODE_KP_INSERT
	KEYCODE_KP_PERIOD,	// KEYCODE_KP_DELETE
	/* 0xa0 - 0xaf */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_KP_MULTIPLY,
	KEYCODE_KP_PLUS,
	KEYCODE_KP_ENTER,
	KEYCODE_KP_MINUS,
	KEYCODE_KP_PERIOD,
	KEYCODE_KP_DIVIDE,
	/* 0xb0 - 0xbf */
	KEYCODE_KP_0,
	KEYCODE_KP_1,
	KEYCODE_KP_2,
	KEYCODE_KP_3,
	KEYCODE_KP_4,
	KEYCODE_KP_5,
	KEYCODE_KP_6,
	KEYCODE_KP_7,
	KEYCODE_KP_8,
	KEYCODE_KP_9,
	0,
	0,
	0,
	0,
	KEYCODE_F1,
	KEYCODE_F2,
	/* 0xc0 - 0xcf */
	KEYCODE_F3,
	KEYCODE_F4,
	KEYCODE_F5,
	KEYCODE_F6,
	KEYCODE_F7,
	KEYCODE_F8,
	KEYCODE_F9,
	KEYCODE_F10,
	KEYCODE_F11,
	KEYCODE_F12,
	KEYCODE_F13,
	KEYCODE_F14,
	KEYCODE_F15,
	KEYCODE_F16,
	KEYCODE_F17,
	KEYCODE_F18,
	/* 0xd0 - 0xdf */
	KEYCODE_F19,
	KEYCODE_F20,
	KEYCODE_F21,
	KEYCODE_F22,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	/* 0xe0 - 0xef */
	0,
	KEYCODE_LSHIFT,
	KEYCODE_RSHIFT,
	KEYCODE_LCTRL,
	KEYCODE_RCTRL,
	KEYCODE_CAPSLOCK,
	0, // KEYCODE_SHIFTLOCK,
	KEYCODE_LALT,
	KEYCODE_RALT,
	KEYCODE_LALT,
	KEYCODE_RALT,
	KEYCODE_LSUPER,
	KEYCODE_RSUPER,
	KEYCODE_LGUI,
	KEYCODE_RGUI,
	0,
	/* 0xf0 - 0xff */
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	KEYCODE_DELETE
};

const uint8_t sdlcode2keycode2[0x50] = {
	/* 0x100 - 0x10f */
	KEYCODE_KP_0,
	KEYCODE_KP_1,
	KEYCODE_KP_2,
	KEYCODE_KP_3,
	KEYCODE_KP_4,
	KEYCODE_KP_5,
	KEYCODE_KP_6,
	KEYCODE_KP_7,
	KEYCODE_KP_8,
	KEYCODE_KP_9,
	KEYCODE_KP_PERIOD,
	KEYCODE_KP_DIVIDE,
	KEYCODE_KP_MULTIPLY,
	KEYCODE_KP_MINUS,
	KEYCODE_KP_PLUS,
	KEYCODE_KP_ENTER,
	/* 0x110 - 0x11f */
	KEYCODE_KP_EQUALS,
	KEYCODE_UP,
	KEYCODE_DOWN,
	KEYCODE_RIGHT,
	KEYCODE_LEFT,
	KEYCODE_INSERT,
	KEYCODE_HOME,
	KEYCODE_END,
	KEYCODE_PAGEUP,
	KEYCODE_PAGEDOWN,
	KEYCODE_F1,
	KEYCODE_F2,
	KEYCODE_F3,
	KEYCODE_F4,
	KEYCODE_F5,
	KEYCODE_F6,
	/* 0x120 - 0x12f */
	KEYCODE_F7,
	KEYCODE_F8,
	KEYCODE_F9,
	KEYCODE_F10,
	KEYCODE_F11,
	KEYCODE_F12,
	KEYCODE_F13,
	KEYCODE_F14,
	KEYCODE_F15,
	0,
	0,
	0,
	KEYCODE_NUMLOCK,
	KEYCODE_CAPSLOCK,
	KEYCODE_SCROLLLOCK,
	KEYCODE_RSHIFT,
	/* 0x130 - 0x13f */
	KEYCODE_LSHIFT,
	KEYCODE_RCTRL,
	KEYCODE_LCTRL,
	KEYCODE_RALT,
	KEYCODE_LALT,
	KEYCODE_RGUI,
	KEYCODE_LGUI,
	KEYCODE_RSUPER,
	KEYCODE_LSUPER,
	KEYCODE_MODE,
	KEYCODE_COMPOSE,
	KEYCODE_HELP,
	KEYCODE_PRINT,
	KEYCODE_SYSREQ,
	0, // KEYCODE_BREAK,
	KEYCODE_MENU,
	/* 0x140 - 0x14f */
	KEYCODE_POWER,
	KEYCODE_EURO,
	KEYCODE_UNDO,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0,
	0
};

typedef struct st_sc2kc {
	short sc;
	short kc;
} sc2kc_t;

#if defined(__FreeBSD__)
const sc2kc_t scancode2keycode[] = {
	{ 0x13, KEYCODE_0 },
	{ 0x15, KEYCODE_CARET },
	{ 0x31, KEYCODE_GRAVE },
	{ 0x42, KEYCODE_CAPSLOCK },
	{ 0x81, KEYCODE_HENKAN },
	{ 0x83, KEYCODE_MUHENKAN },
	{ 0x84, KEYCODE_BACKSLASH },
	{ 0xd0, KEYCODE_KATAHIRA },
	{ 0xd3, KEYCODE_UNDERSCORE },
	{ -1, -1 }
};
#else
	/* linux */
const sc2kc_t scancode2keycode[] = {
	{ 0x13, KEYCODE_0 },
	{ 0x15, KEYCODE_CARET },
	{ 0x31, KEYCODE_GRAVE },
	{ 0x42, KEYCODE_CAPSLOCK },
	{ 0x61, KEYCODE_UNDERSCORE },
	{ 0x64, KEYCODE_HENKAN },
	{ 0x65, KEYCODE_KATAHIRA },
	{ 0x66, KEYCODE_MUHENKAN },
	{ 0x84, KEYCODE_BACKSLASH },
	{ -1, -1 }
};
#endif

#endif /* USE_GTK */

#ifdef USE_AUTO_KEY

#define AUTO_KEY_SHIFT	0x87
#define AUTO_KEY_RETURN	0xaf
#define AUTO_KEY_KANA	0x8a
#define AUTO_KEY_GRAPH	0x8b
#define AUTO_KEY_NONE	0xff
#define AUTO_KEY_MASK		0x00ff
#define AUTO_KEY_SHIFT_MASK	0x0100
#define AUTO_KEY_GRAPH_MASK	0x0200
#define AUTO_KEY_UPPER_MASK	0x0400
#define AUTO_KEY_LOWER_MASK	0x0800

static const int autokey_table[256] = {
	// 0x100: shift
	// 0x200: graph
	// 0x400: alphabet
	// 0x800: ALPHABET
	// 0x1000: katakana
	// 0x2000: hiragana
	// use vm key scan code 0x80 - 0xfe
	0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x0af,0x000,0x000,0x0af,0x000,0x000,
	0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x000,0x08c,0x083,0x085,0x081,0x084,
	0x080,0x19a,0x19b,0x197,0x191,0x199,0x192,0x190,0x193,0x19c,0x1b6,0x1b4,0x0c3,0x096,0x0cc,0x0c4,
	0x094,0x09a,0x09b,0x097,0x091,0x099,0x092,0x090,0x093,0x09c,0x0b6,0x0b4,0x1c3,0x196,0x1cc,0x1c4,
	0x0a6,0x4b8,0x4c9,0x4cb,0x4bb,0x4ab,0x4b1,0x4b9,0x4b2,0x4a3,0x4b0,0x4b3,0x4bc,0x4c0,0x4c2,0x4ac,
	0x4a4,0x4a8,0x4a1,0x4ba,0x4a9,0x4a0,0x4c1,0x4aa,0x4ca,0x4a2,0x4c8,0x0a5,0x09f,0x0b5,0x095,0x1c6,
	0x000,0x8b8,0x8c9,0x8cb,0x8bb,0x8ab,0x8b1,0x8b9,0x8b2,0x8a3,0x8b0,0x8b3,0x8bc,0x8c0,0x8c2,0x8ac,
	0x8a4,0x8a8,0x8a1,0x8ba,0x8a9,0x8a0,0x8c1,0x8aa,0x8ca,0x8a2,0x8c8,0x000,0x000,0x000,0x000,0x000,
	// hiragana1
	0x2c8,0x2ca,0x2cb,0x2c1,0x2c9,0x2c2,0x2c0,0x2c3,0x2cc,0x2bc,0x2ac,0x29c,0x293,0x2a3,0x2b3,0x2bd,
	0x2cd,0x28d,0x2be,0x2b7,0x2b4,0x2bf,0x2cf,0x2c4,0x29d,0x28e,0x2c7,0x2ce,0x2a1,0x2a9,0x2b1,0x2b9,
	// katakana
	0x029a,0x11cc,0x11a5,0x11b5,0x11c3,0x11c4,0x1194,0x1197,0x11ab,0x1191,0x1199,0x1192,0x1190,0x1193,0x119c,0x11c8,
	0x109f,0x1097,0x10ab,0x1091,0x1099,0x1092,0x10a9,0x10b9,0x10b2,0x10b6,0x10c9,0x10ca,0x10bb,0x10a1,0x10a4,0x10cb,
	0x10a8,0x10b8,0x10c8,0x10aa,0x10ba,0x10a0,0x10a3,0x109a,0x10c3,0x10b3,0x10b1,0x10c1,0x109b,0x1095,0x1096,0x10b0,
	0x10c2,0x10b5,0x10c4,0x10c0,0x1090,0x1093,0x109c,0x10ac,0x10bc,0x10cc,0x10b4,0x10c6,0x1094,0x10a2,0x10a6,0x10a5,
	// hiragana2
	0x296,0x2a6,0x2b6,0x2c6,0x2a2,0x2a0,0x2b2,0x2b0,0x2a8,0x2b8,0x2aa,0x2ba,0x2ab,0x2bb,0x2c5,0x28f,
	0x2a7,0x29f,0x29b,0x297,0x291,0x299,0x292,0x290,0x2ad,0x294,0x2a4,0x295,0x2a5,0x20a2,0x2b5,0x000,
};
#endif

#endif /* GTK_INPUT_H */
