#include "audiodev.h"

//-- sine wave sample
BYTE SineWaveSample[32] = 
{
   0x00, 0x00, 0x00, 0x00, 0x22, 0x22, 0x22, 0x22, 
   0x44, 0x44, 0x44, 0x44, 0x22, 0x22, 0x22, 0x22, 
   0x00, 0x00, 0x00, 0x00, 0xdd, 0xdd, 0xdd, 0xdd, 
   0xbb, 0xbb, 0xbb, 0xbb, 0xdd, 0xdd, 0xdd, 0xdd
};

AudioDev::AudioDev(int voices, int waves, int rate, int len, int dev)
{
   Voices = voices;
   SampleRate = rate;
   SampleLength = len;
   NextSample = waves;

	int i;
   unsigned int ndevice;
   AUDIOINFO info;

   pGame->Disp()->PrintStr("Initializing Audio", 0x00, 0x38);
   pGame->Disp()->Draw();
   if (AInitialize())
      {
      Voices = 0;         
      pGame->Disp()->PrintStr("Error Initializing Audio", 0x10, 0x20);
      pGame->Disp()->PrintStr("Hit any key", 0x18, 0x58);
      pGame->Disp()->Draw();
      pGame->KB().Clear();
      pGame->KB().ReadKey();
      return;
      }

	APingAudio(&ndevice);

   info.wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;
   info.nSampleRate = SampleRate;

   if (dev == AUDIO_PRODUCT_SB16)
      {
      info.wFormat = AUDIO_FORMAT_16BITS | AUDIO_FORMAT_STEREO;
   	info.nDeviceId = AUDIO_PRODUCT_SB16;
      }
	else if (dev == AUDIO_PRODUCT_SB)
   	info.nDeviceId = AUDIO_PRODUCT_SB;
   else
      info.nDeviceId = AUDIO_DEVICE_MAPPER;


   if (AOpenAudio(&info))
      {
      Voices = 0;         
      pGame->Disp()->PrintStr("Error Opening Audio", 0x10, 0x38);
      pGame->Disp()->PrintStr("Hit any key", 0x18, 0x58);
      pGame->Disp()->Draw();
      pGame->KB().Clear();
      pGame->KB().ReadKey();
      lpWave = 0;
      hVoice = 0;
      return;
      }

   hVoice = new HAC[Voices];
   lpWave = new LPAUDIOWAVE[Voices];
	AOpenVoices(Voices);

   //-- allocate voices and waveforms
   for(i=0; i<Voices; i++)
      {
      ACreateAudioVoice(&hVoice[i]);
      ASetVoicePanning(hVoice[i], 0x80);

      if ((lpWave[i] = new AUDIOWAVE) == 0)
         {
         //-- ERROR - free audio memory and exit
         int j;
         for(j=0; j<i; j++)
            {
            ADestroyAudioVoice(hVoice[j]);
            ADestroyAudioData(lpWave[j]);
            delete lpWave[j];
            }
         ADestroyAudioVoice(hVoice[i]);
         Voices = 0;         
         return;
         }

      if (i < Voices-waves)
         {
         lpWave[i]->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;
         lpWave[i]->nSampleRate = SampleRate;
         lpWave[i]->dwLength = SampleLength;
         lpWave[i]->dwLoopStart = lpWave[i]->dwLoopEnd = 0;

         if (ACreateAudioData(lpWave[i]) != AUDIO_ERROR_NONE)
            {
            //-- ERROR - free audio memory
            int j;
            for(j=0; j<i; j++)
               {
               ADestroyAudioVoice(hVoice[j]);
               ADestroyAudioData(lpWave[j]);
               delete lpWave[j];
               }
            ADestroyAudioVoice(hVoice[i]);
            delete lpWave[i];
            Voices = 0;         
            return;
            }
         }
      }
}

AudioDev::~AudioDev()
{
   if (Voices)
      {
      for(int i=0; i<Voices; i++)
         {
         AStopVoice(hVoice[i]);
         ADestroyAudioVoice(hVoice[i]);
         delete lpWave[i];
         }
      }

   //-- stop audio
   ACloseVoices();
   ACloseAudio();
   if (lpWave) delete []lpWave;
   if (hVoice) delete []hVoice;
}

void AudioDev::PlaySample (int channel, BYTE *data, int len, int freq, int vol, int loop)
{
   //-- sanity check
	if (channel >= Voices)
      return;

   memcpy(lpWave[channel]->lpData, data, len);
   lpWave[channel]->wFormat = AUDIO_FORMAT_8BITS | AUDIO_FORMAT_MONO;
   if (loop)
      lpWave[channel]->wFormat |= AUDIO_FORMAT_LOOP;
   lpWave[channel]->dwLoopStart = 0;
   lpWave[channel]->dwLoopEnd = len;
   lpWave[channel]->dwLength = len;

   AWriteAudioData(lpWave[channel], 0, len);
   APlayVoice(hVoice[channel], lpWave[channel]);
   ASetVoiceFrequency(hVoice[channel], freq);
   ASetVoiceVolume(hVoice[channel], vol>>2);
}

void AudioDev::AdjustSample (int channel, int freq, int vol)
{
   //-- sanity check
	if (channel >= Voices)
      return;

   if (freq == 512000) vol = 0;
   ASetVoiceFrequency(hVoice[channel], freq);
   ASetVoiceVolume(hVoice[channel], vol>>2);
}



