#include <stdio.h>
#include "display.h"
#include "game.h"

//-- color intensity based on 2 or 3 bit definition in color ROMs
BYTE intensity4[] = { 0, 31, 47, 63 };
BYTE intensity8[] = { 0, 15, 23, 31, 39, 47, 55, 63 };

Register scr256x256[] =
{
	{ 0x3c2, 0x00, 0xe3},{ 0x3d4, 0x00, 0x5f},{ 0x3d4, 0x01, 0x3f},
	{ 0x3d4, 0x02, 0x40},{ 0x3d4, 0x03, 0x82},{ 0x3d4, 0x04, 0x4A},
	{ 0x3d4, 0x05, 0x9A},{ 0x3d4, 0x06, 0x23},{ 0x3d4, 0x07, 0xb2},
	{ 0x3d4, 0x08, 0x00},{ 0x3d4, 0x09, 0x61},{ 0x3d4, 0x10, 0x0a},
	{ 0x3d4, 0x11, 0xac},{ 0x3d4, 0x12, 0xff},{ 0x3d4, 0x13, 0x20},
	{ 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0x07},{ 0x3d4, 0x16, 0x1a},
	{ 0x3d4, 0x17, 0xa3},{ 0x3c4, 0x01, 0x01},{ 0x3c4, 0x04, 0x0e},
	{ 0x3ce, 0x05, 0x40},{ 0x3ce, 0x06, 0x05},{ 0x3c0, 0x10, 0x41},
	{ 0x3c0, 0x13, 0x00}
};

Register scr224x256[] =
{
	{ 0x3c2, 0x0, 0xe3},	{ 0x3d4, 0x0, 0x5f},	{ 0x3d4, 0x1, 0x37},
	{ 0x3d4, 0x2, 0x40},	{ 0x3d4, 0x3, 0x82},	{ 0x3d4, 0x4, 0x4a},
	{ 0x3d4, 0x5, 0x9a},	{ 0x3d4, 0x6, 0x23},	{ 0x3d4, 0x7, 0xb2},
	{ 0x3d4, 0x8, 0x0},	{ 0x3d4, 0x9, 0x61},	{ 0x3d4, 0x10, 0xa},
	{ 0x3d4, 0x11, 0xac},{ 0x3d4, 0x12, 0xff},{ 0x3d4, 0x13, 0x20},
	{ 0x3d4, 0x14, 0x40},{ 0x3d4, 0x15, 0x7},	{ 0x3d4, 0x16, 0x1a},
	{ 0x3d4, 0x17, 0xa3},{ 0x3c4, 0x1, 0x1},	{ 0x3c4, 0x4, 0xe},
	{ 0x3ce, 0x5, 0x40},	{ 0x3ce, 0x6, 0x5},	{ 0x3c0, 0x10, 0x41},
	{ 0x3c0, 0x13, 0x0}
};

//-- ModeQ Display Constructor
Display::Display(int dw, int dh, int gw, int gh, int gx, int gy, 
   int dx, int dy, Register *scr, int len)
{
   DisplayWidth = dw;
   DisplayHeight = dh;
   GameWidth = gw;
   GameHeight = gh;
   GameXOffset = gx;
   GameYOffset = gy;
   DisplayXOffset = dx;
   DisplayYOffset = dy;
   Screen = scr;
	int reglen = 0;
   int videofreq = 0;
   DisplayMode = MODEQ;

 	set_gfx_mode(GFX_VGA,320,200,0,0);
   reglen = len/sizeof(Register);
 	scr[0].value = (scr[0].value & 0xf3) | (videofreq << 2);
   outRegArray(scr,reglen);

   pPicture = create_bitmap(256, 256);
   pBackground = create_bitmap(256, 256);
   pText = create_bitmap(320, 8);

   for (int i=0; i<256; i++)
      {
      pPalette[i].r = intensity8[i&0x7];
      pPalette[i].g = intensity8[(i&0x38)>>3];
      pPalette[i].b = intensity4[(i&0xc0)>>6];
      }

   set_palette(pPalette);

   clear (pPicture);
   clear (pBackground);
   clear (screen);
}

//-- ModeX Display Constructor
Display::Display(int dw, int dh, int gw, int gh, int gx, int gy, 
   int dx, int dy)
{
   DisplayWidth = dw;
   DisplayHeight = dh;
   GameWidth = gw;
   GameHeight = gh;
   GameXOffset = gx;
   GameYOffset = gy;
   DisplayXOffset = dx;
   DisplayYOffset = dy;
   Screen = 0;
   DisplayMode = MODEX;
   ActivePage = 0;

 	set_gfx_mode(GFX_MODEX,320, 240, 320, 480);

   pPicture = create_bitmap(320, 240);
   pBackground = create_bitmap(320, 240);
   pText = create_bitmap(320, 8);

   for (int i=0; i<256; i++)
      {
      pPalette[i].r = intensity8[i&0x7];
      pPalette[i].g = intensity8[(i&0x38)>>3];
      pPalette[i].b = intensity4[(i&0xc0)>>6];
      }

   set_palette(pPalette);

   clear (pPicture);
   clear (pBackground);
   clear (screen);
}

Display::~Display()
{
   //-- destroy the bitmaps
   destroy_bitmap(pText);
   destroy_bitmap(pBackground);
   destroy_bitmap(pPicture);
}

void Display::Draw()
{
   if (DisplayMode == MODEX)
      {
      if (ActivePage)
         xblit (pPicture, screen, GameXOffset, GameYOffset,
            DisplayXOffset, DisplayYOffset, GameWidth, GameHeight, 0);
      else
         xblit (pPicture, screen, GameXOffset, GameYOffset, DisplayXOffset,
            DisplayYOffset+DisplayHeight, GameWidth, GameHeight, DisplayHeight);
      ActivePage ^= 1;
      }
   else
      xblast (pPicture, GameWidth, GameXOffset);
}

void Display::PrintHex(int num, int row, int col)
{
   char buf[4];
   sprintf (buf, "%02X", num);
   PrintStr (buf, row, col);
}

// display a number
void Display::PrintNum(int num, int row, int col)
{
   char buf[20];
   sprintf (buf, "%u", num);
   PrintStr (buf, row, col);
}

// display a string
void Display::PrintStr(char *str, int row, int col)
{
   int x;
   BYTE b;

   while (*str)
      {
      b = *str;
      if (b >= '0' && b <= '9')
         {
         x = (b-'0')*8;
         }
      else if ((b >= 'A' && b <= 'Z') || (b >= 'a' && b <= 'z'))
         {
         b &= 0xdf;
         x = (b-'A'+10)*8;
         }
      else if (b == '.')
         {
         x = 36*8;
         }
      else
         {
         x = 37*8;
         }
     	blit (pText, pPicture, x, 0, col,row, 8,8);
      col += 8;
      str++;
	   }
}



