#ifndef __EXIDY_H__
#define __EXIDY_H__

#include "game.h"
 #include "proc6502.h"

BYTE ExidyReadPlayer(WORD A);

class Exidy : public Game
{
private:
   BYTE BackBuffer[0x400];
   BYTE CharBuffer[0x100];
protected:
   Proc6502 *  pProc6502;
   virtual void Video();
   virtual void Audio();
   virtual void DrawCharacter (int c, int col, int row);
   virtual void DrawSprite (int c, int col, int row, BYTE color);
   virtual void DetectCollision();
public:
   Exidy(ROMS *pR, ROMS *pSR, char *path);
   virtual ~Exidy();
   virtual void Reset();
   virtual void Execute();
   virtual int  Interrupt();
   virtual void Load();
   virtual void Save();
   void GetTextChar(WORD sAdd, WORD dOff);
   BYTE * Background() { return BackBuffer; };
   BYTE * Characters() { return CharBuffer; };
   IOPort * Player0;
   IOPort * Player1;
   IOPort * Player2;
   DipSwitch * Dipswitch;
   int Collision;
};

extern Exidy * pExidy;

#endif

